/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: TraceInterceptorUsingBundleClassLoader.java 20136 2010-07-30 15:31:53Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.component;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.TraceInterceptor;
import org.apache.camel.processor.interceptor.Tracer;

/**
 * CAMEL tracer with the bundle's ClassLoader.
 */
class TraceInterceptorUsingBundleClassLoader extends TraceInterceptor {

    public TraceInterceptorUsingBundleClassLoader(final ProcessorDefinition node, final Processor target,
        final TraceFormatter formatter, final Tracer tracer) {

        super(node, target, formatter, tracer);
    }

    @Override
    public void process(final Exchange exchange) throws Exception {
        final ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        try {
            final ExchangePattern oldPattern = exchange.getPattern();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                // We need to use pattern ExchangePattern.InOnly as some components
                // (for example, CXF) set the Exchange as ExchangePattern.InOut;
                // which might result in ExchangeTimedOutExceptions being thrown,
                // unwanted stack traces being logged or unneeded delays.
                exchange.setPattern(ExchangePattern.InOnly);
                super.process(exchange);
            } finally {
                exchange.setPattern(oldPattern);
            }
        } finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
    }
}
