/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.component;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;

public class ProducerProcessorUsingBundleClassLoader
implements Processor {
    private final String destination;
    private final String toString;

    public ProducerProcessorUsingBundleClassLoader(String destination) {
        this.destination = destination;
        StringBuilder toString = new StringBuilder();
        toString.append(this.getClass().getName());
        toString.append("[destination=");
        toString.append(destination);
        toString.append("]");
        this.toString = toString.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Endpoint trace = exchange.getContext().getEndpoint(this.destination);
            Producer producer = trace.createProducer();
            Exchange exchangeCopy = exchange.copy();
            exchangeCopy.setPattern(ExchangePattern.InOnly);
            producer.process(exchangeCopy);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
    }

    public String toString() {
        return this.toString;
    }
}

