/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.component;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.strategy.GenericFileProcessStrategyFactory;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.impl.CompositeRegistry;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.Registry;
import org.apache.cxf.tools.common.extensions.soap.SoapBinding;
import org.osgi.framework.BundleContext;
import org.ow2.carol.jndi.intercept.spi.InterceptorInitialContextFactory;
import org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory;
import org.ow2.jonas.camel.component.DefaultTraceEventMessageToStringProcessor;
import org.ow2.jonas.camel.component.MessageFormatter;
import org.ow2.jonas.camel.component.ProducerProcessorUsingBundleClassLoader;
import org.ow2.jonas.camel.component.RegistryInjector;
import org.ow2.jonas.camel.service.api.ICamelService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.JndiDestinationResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RouteBuilderComponent
extends RouteBuilder {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String TRACE_LOGGER_NAME = "org.ow2.jonas.camel.traces";
    protected BundleContext bundleContext = null;
    protected ICamelService camelService = null;
    protected Map<String, String> registryReplacements = new HashMap<String, String>();
    private Map<String, String> allRegistryPropertiesAndReplacements;
    protected String camelContextName = null;
    protected String traceDestination = null;
    private File conf;

    public RouteBuilderComponent(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        String JONAS_BASE = System.getProperty("jonas.base");
        if (JONAS_BASE == null) {
            throw new RuntimeException("JONAS_BASE not defined");
        }
        this.conf = new File(JONAS_BASE, "conf").getAbsoluteFile();
        MultiOrbInitialContextFactory.class.getClassLoader();
        InterceptorInitialContextFactory.class.getClassLoader();
        GenericFileProcessStrategyFactory.class.getClassLoader();
        SoapBinding.class.getClassLoader();
        QName.class.getClassLoader();
    }

    public void start() throws Throwable {
        this.logger.debug((Object)"Starting route {0}", new Object[]{this.getRouteName()});
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.logger.debug((Object)"Starting CAMEL context for route {0}", new Object[]{this.getRouteName()});
            this.camelContextName = this.camelService.startNewContext(this.bundleContext);
            DefaultCamelContext camelContext = (DefaultCamelContext)this.camelService.getCamelContext(this.camelContextName);
            this.logger.debug((Object)"Adding registry entries for route {0}", new Object[]{this.getRouteName()});
            RegistryInjector injector = new RegistryInjector(this.registryReplacements);
            this.configureCamelComponents((CamelContext)camelContext, injector.getRegistryFilesContent());
            this.logger.debug((Object)"Injecting registry entries for route {0}", new Object[]{this.getRouteName()});
            injector.injectRegistry(this.camelService, this.camelContextName);
            this.allRegistryPropertiesAndReplacements = injector.getAllReplacements();
            this.logger.debug((Object)"Adding the JNDI registry to route {0}", new Object[]{this.getRouteName()});
            JndiRegistry jndiRegistry = new JndiRegistry((Context)new InitialContext());
            CompositeRegistry compositeRegistry = new CompositeRegistry();
            compositeRegistry.addRegistry(camelContext.getRegistry());
            compositeRegistry.addRegistry((Registry)jndiRegistry);
            camelContext.setRegistry((Registry)compositeRegistry);
            this.logger.debug((Object)"Starting CAMEL routes on {0}", new Object[]{this.getRouteName()});
            this.camelService.addRoutes((RouteBuilder)this, this.camelContextName);
            this.logger.info((Object)"Route {0} has started", new Object[]{this.getRouteName()});
        }
        catch (Throwable t) {
            this.logger.error((Object)"Cannot start route {0}", new Object[]{this.getRouteName(), t});
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    public void stop() throws Throwable {
        try {
            if (this.camelContextName != null) {
                this.camelService.stop(this.camelContextName);
            }
            this.logger.info((Object)"Route {0} has stopped", new Object[]{this.getRouteName()});
        }
        catch (Throwable t) {
            this.logger.error((Object)"Cannot stop route {0}", new Object[]{this.getRouteName(), t});
            throw t;
        }
        finally {
            this.camelContextName = null;
            this.camelService = null;
            System.gc();
        }
    }

    protected void configureCamelComponents(CamelContext camelContext, List<String> registryFilesContent) throws Exception {
        JmsComponent jms = (JmsComponent)camelContext.getComponent("jms", JmsComponent.class);
        ConnectionFactory connectionFactory = (ConnectionFactory)new InitialContext().lookup("JCF");
        jms.setConnectionFactory(connectionFactory);
        JndiDestinationResolver jndiDestinationResolver = new JndiDestinationResolver();
        jndiDestinationResolver.setCache(true);
        jms.setDestinationResolver((DestinationResolver)jndiDestinationResolver);
    }

    public void configure() throws Exception {
        if (this.traceDestination != null) {
            Tracer tracer = new Tracer();
            tracer.setFormatter((TraceFormatter)new MessageFormatter());
            tracer.setLogLevel(LoggingLevel.INFO);
            tracer.setLogName(TRACE_LOGGER_NAME);
            tracer.setTraceExceptions(false);
            tracer.setDestinationUri("direct:traced");
            ((RouteDefinition)this.from("direct:traced").process((Processor)new DefaultTraceEventMessageToStringProcessor())).process((Processor)new ProducerProcessorUsingBundleClassLoader(this.traceDestination));
            this.getContext().addInterceptStrategy((InterceptStrategy)tracer);
        }
    }

    public void setCamelService(ICamelService camelService) {
        this.camelService = camelService;
    }

    public final File getConfigurationFolder() {
        return this.conf;
    }

    public final String getRegistryPropertyOrReplacement(String key) {
        String result = this.allRegistryPropertiesAndReplacements.get(key);
        if (result == null) {
            throw new IllegalArgumentException("Registry property files in the " + this.conf + " folder do not contain the key " + key + ". Full contents of properties: " + this.allRegistryPropertiesAndReplacements);
        }
        return result;
    }

    public String getRouteName() {
        String location = this.bundleContext.getBundle().getLocation();
        int lastSlash = (location = location.replace('\\', '/')).lastIndexOf(47);
        if (lastSlash != -1) {
            location = location.substring(lastSlash + 1);
        }
        if (location.endsWith(".jar")) {
            location = location.substring(0, location.length() - 4);
        }
        return location;
    }

    public File getFileEndpointFile(String url) {
        FileEndpoint endpoint = (FileEndpoint)this.getContext().getEndpoint(url, FileEndpoint.class);
        if (endpoint == null) {
            throw new ResolveEndpointFailedException("Cannot find " + url);
        }
        return endpoint.getFile();
    }
}

