/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.example.cxf.route;

import java.io.InputStream;
import java.util.Set;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.message.MessageContentsList;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.ow2.jonas.camel.example.cxf.webservice.api.ISayHello;
import org.ow2.jonas.camel.service.api.ICamelService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ExampleCXF
implements Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private Log logger;
    private boolean __FcamelService;
    private ICamelService camelService;
    private boolean __FcamelContextName;
    private String camelContextName;
    private boolean __FbundleContext;
    private BundleContext bundleContext;
    private boolean __Mstart;
    private boolean __Mtest;
    private boolean __Mstop;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    ICamelService __getcamelService() {
        if (!this.__FcamelService) {
            return this.camelService;
        }
        return (ICamelService)this.__IM.onGet((Object)this, "camelService");
    }

    void __setcamelService(ICamelService iCamelService) {
        if (!this.__FcamelService) {
            this.camelService = iCamelService;
            return;
        }
        this.__IM.onSet((Object)this, "camelService", (Object)iCamelService);
    }

    String __getcamelContextName() {
        if (!this.__FcamelContextName) {
            return this.camelContextName;
        }
        return (String)this.__IM.onGet((Object)this, "camelContextName");
    }

    void __setcamelContextName(String string) {
        if (!this.__FcamelContextName) {
            this.camelContextName = string;
            return;
        }
        this.__IM.onSet((Object)this, "camelContextName", (Object)string);
    }

    BundleContext __getbundleContext() {
        if (!this.__FbundleContext) {
            return this.bundleContext;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "bundleContext");
    }

    void __setbundleContext(BundleContext bundleContext) {
        if (!this.__FbundleContext) {
            this.bundleContext = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "bundleContext", (Object)bundleContext);
    }

    public ExampleCXF(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private ExampleCXF(InstanceManager _manager, BundleContext bundleContext) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(this.getClass()));
        this.__setcamelService(null);
        this.__setcamelContextName(null);
        this.__setbundleContext(bundleContext);
    }

    public void start() throws Throwable {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __start() throws Throwable {
        ClassLoader bundleCL = this.getClass().getClassLoader();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            RouteBuilder builder = new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("registry:cxfToFile").process(new Processor(){

                        public void process(Exchange exchange) throws Exception {
                            MessageContentsList msgList = (MessageContentsList)exchange.getIn().getBody(MessageContentsList.class);
                            String name = (String)msgList.get(0);
                            ExampleCXF.this.__getlogger().info((Object)"Received CXF message {0}", new Object[]{name});
                            MessageContentsList response = new MessageContentsList();
                            response.add((Object)("hello, " + name));
                            exchange.getOut().setBody((Object)response);
                        }
                    });
                }
            };
            this.__setcamelContextName(this.__getcamelService().startNewContext());
            this.__getlogger().info((Object)"Camel context {0} started", new Object[]{this.__getcamelContextName()});
            InputStream input = bundleCL.getResourceAsStream("cxf-registry.xml");
            this.__getcamelService().addRegistry(input, this.__getcamelContextName());
            this.__getcamelService().addComponent("cxf", (Component)new CxfComponent(), this.__getcamelContextName());
            try {
                Thread.currentThread().setContextClassLoader(bundleCL);
                this.__getcamelService().addRoutes(builder, this.__getcamelContextName());
                this.test();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
        catch (Throwable t) {
            this.__getlogger().error((Object)"Cannot start ExampleCXF", new Object[]{t});
            throw t;
        }
    }

    public void test() {
        if (!this.__Mtest) {
            this.__test();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "test", new Object[0]);
            this.__test();
            this.__IM.onExit((Object)this, "test", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "test", throwable);
            throw throwable;
        }
    }

    private void __test() {
        ServiceReference httpService = this.__getbundleContext().getServiceReference(HttpService.class.getName());
        if (httpService == null) {
            throw new NullPointerException("HttpService is not registered");
        }
        String port = (String)httpService.getProperty("org.osgi.service.http.port");
        ClientProxyFactoryBean factory = new ClientProxyFactoryBean();
        factory.setServiceClass(ISayHello.class);
        factory.setAddress("http://localhost:" + port + "/services/SayHello");
        ISayHello client = (ISayHello)factory.create();
        String response = client.hello("guillaume");
        this.__getlogger().info((Object)"Got CXF response {0}", new Object[]{response});
    }

    public void stop() throws Exception {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __stop() throws Exception {
        try {
            this.__getcamelService().stop(this.__getcamelContextName());
        }
        finally {
            this.__setcamelContextName(null);
            this.__setcamelService(null);
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("bundleContext")) {
                this.__FbundleContext = true;
            }
            if (set.contains("camelService")) {
                this.__FcamelService = true;
            }
            if (set.contains("camelContextName")) {
                this.__FcamelContextName = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("test")) {
                this.__Mtest = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

