/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.example.cxf.route;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.message.MessageContentsList;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.ow2.jonas.camel.example.cxf.webservice.api.ISayHello;
import org.ow2.jonas.camel.service.api.ICamelService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ExampleCXF
implements Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private Log logger;
    private boolean __FcamelService;
    private ICamelService camelService;
    private boolean __FcamelContextName;
    private String camelContextName;
    private boolean __FbundleContext;
    private BundleContext bundleContext;
    private boolean __FhttpPort;
    private String httpPort;
    private boolean __Mstart;
    private boolean __Mtest;
    private boolean __Mstop;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    ICamelService __getcamelService() {
        if (!this.__FcamelService) {
            return this.camelService;
        }
        return (ICamelService)this.__IM.onGet((Object)this, "camelService");
    }

    void __setcamelService(ICamelService iCamelService) {
        if (!this.__FcamelService) {
            this.camelService = iCamelService;
            return;
        }
        this.__IM.onSet((Object)this, "camelService", (Object)iCamelService);
    }

    String __getcamelContextName() {
        if (!this.__FcamelContextName) {
            return this.camelContextName;
        }
        return (String)this.__IM.onGet((Object)this, "camelContextName");
    }

    void __setcamelContextName(String string) {
        if (!this.__FcamelContextName) {
            this.camelContextName = string;
            return;
        }
        this.__IM.onSet((Object)this, "camelContextName", (Object)string);
    }

    BundleContext __getbundleContext() {
        if (!this.__FbundleContext) {
            return this.bundleContext;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "bundleContext");
    }

    void __setbundleContext(BundleContext bundleContext) {
        if (!this.__FbundleContext) {
            this.bundleContext = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "bundleContext", (Object)bundleContext);
    }

    String __gethttpPort() {
        if (!this.__FhttpPort) {
            return this.httpPort;
        }
        return (String)this.__IM.onGet((Object)this, "httpPort");
    }

    void __sethttpPort(String string) {
        if (!this.__FhttpPort) {
            this.httpPort = string;
            return;
        }
        this.__IM.onSet((Object)this, "httpPort", (Object)string);
    }

    public ExampleCXF(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private ExampleCXF(InstanceManager _manager, BundleContext bundleContext) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(this.getClass()));
        this.__setcamelService(null);
        this.__setcamelContextName(null);
        this.__setbundleContext(bundleContext);
    }

    public void start() throws Throwable {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __start() throws Throwable {
        ServiceReference httpService = this.__getbundleContext().getServiceReference(HttpService.class.getName());
        if (httpService == null) {
            throw new NullPointerException("HttpService is not registered");
        }
        this.__sethttpPort((String)httpService.getProperty("org.osgi.service.http.port"));
        ClassLoader bundleCL = this.getClass().getClassLoader();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            RouteBuilder helloService = new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("registry:helloService").process(new Processor(){

                        public void process(Exchange exchange) throws Exception {
                            MessageContentsList msgList = (MessageContentsList)exchange.getIn().getBody(MessageContentsList.class);
                            String name = (String)msgList.get(0);
                            ExampleCXF.this.__getlogger().info((Object)"Received CXF message: {0}", new Object[]{name});
                            MessageContentsList response = new MessageContentsList();
                            response.add((Object)("hello, " + name));
                            exchange.getOut().setBody((Object)response);
                        }
                    });
                }
            };
            RouteBuilder fileToHelloService = new RouteBuilder(){
                Map<String, String> filenames = new HashMap<String, String>();

                public void configure() throws Exception {
                    File source = new File("target/fileToHelloService/requests");
                    source.mkdirs();
                    File target = new File("target/fileToHelloService/responses");
                    target.mkdirs();
                    this.from(source.getAbsoluteFile().toURL().toString() + "?delete=true&readLock=changed").process(new Processor(){

                        public void process(Exchange exchange) throws Exception {
                            filenames.put(exchange.getExchangeId(), (String)exchange.getIn().getHeader("CamelFileName", String.class));
                            String message = (String)exchange.getIn().getBody(String.class);
                            exchange.getOut().setHeader("operationName", (Object)"hello");
                            MessageContentsList msgList = new MessageContentsList();
                            msgList.add(0, (Object)message);
                            exchange.getOut().setBody((Object)msgList);
                        }
                    }).to("registry:helloService").process(new Processor(){

                        public void process(Exchange exchange) throws Exception {
                            String filename = filenames.remove(exchange.getExchangeId());
                            exchange.getOut().setHeader("CamelFileName", (Object)filename);
                            exchange.getOut().setBody(exchange.getIn().getBody());
                        }
                    }).to(target.getAbsoluteFile().toURL().toString());
                }
            };
            this.__setcamelContextName(this.__getcamelService().startNewContext());
            this.__getlogger().info((Object)"Camel context {0} started", new Object[]{this.__getcamelContextName()});
            this.__getcamelService().addComponent("cxf", (Component)new CxfComponent(), this.__getcamelContextName());
            InputStream input = bundleCL.getResourceAsStream("cxf-registry.xml");
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                line = line.replace("$http.port", this.__gethttpPort());
                sb.append(line);
                sb.append('\n');
            }
            reader.close();
            input.close();
            input = new ByteArrayInputStream(sb.toString().getBytes());
            this.__getcamelService().addRegistry(input, this.__getcamelContextName());
            try {
                Thread.currentThread().setContextClassLoader(bundleCL);
                this.__getcamelService().addRoutes(helloService, this.__getcamelContextName());
                this.__getcamelService().addRoutes(fileToHelloService, this.__getcamelContextName());
                this.test();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
        catch (Throwable t) {
            this.__getlogger().error((Object)"Cannot start ExampleCXF", new Object[]{t});
            throw t;
        }
    }

    public void test() throws Exception {
        if (!this.__Mtest) {
            this.__test();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "test", new Object[0]);
            this.__test();
            this.__IM.onExit((Object)this, "test", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "test", throwable);
            throw throwable;
        }
    }

    private void __test() throws Exception {
        ClientProxyFactoryBean factory = new ClientProxyFactoryBean();
        factory.setServiceClass(ISayHello.class);
        factory.setAddress("http://localhost:" + this.__gethttpPort() + "/services/SayHello");
        ISayHello client = (ISayHello)factory.create();
        String response = client.hello("guillaume");
        this.__getlogger().info((Object)"Got CXF response: {0}", new Object[]{response});
        File selfTestDir = new File("target/fileToHelloService/requests");
        selfTestDir.mkdirs();
        File selfTest = new File(selfTestDir, "selfTest.txt").getAbsoluteFile();
        FileOutputStream fo = new FileOutputStream(selfTest);
        fo.write("ali".getBytes());
        fo.close();
    }

    public void stop() throws Exception {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __stop() throws Exception {
        try {
            this.__getcamelService().stop(this.__getcamelContextName());
        }
        finally {
            this.__setcamelContextName(null);
            this.__setcamelService(null);
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("bundleContext")) {
                this.__FbundleContext = true;
            }
            if (set.contains("camelService")) {
                this.__FcamelService = true;
            }
            if (set.contains("camelContextName")) {
                this.__FcamelContextName = true;
            }
            if (set.contains("httpPort")) {
                this.__FhttpPort = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("test")) {
                this.__Mtest = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

