/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.example.cxf.route;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.RouteDefinition;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.message.MessageContentsList;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.ow2.jonas.camel.component.RouteBuilderComponent;
import org.ow2.jonas.camel.example.cxf.webservice.api.ISayHello;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ExampleCXF
extends RouteBuilderComponent
implements Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private Log logger;
    private boolean __FhttpPort;
    private String httpPort;
    private boolean __Ffilenames;
    private Map<String, String> filenames;
    private boolean __Mstart;
    private boolean __Mconfigure;
    private boolean __Mtest;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    String __gethttpPort() {
        if (!this.__FhttpPort) {
            return this.httpPort;
        }
        return (String)this.__IM.onGet((Object)this, "httpPort");
    }

    void __sethttpPort(String string) {
        if (!this.__FhttpPort) {
            this.httpPort = string;
            return;
        }
        this.__IM.onSet((Object)this, "httpPort", (Object)string);
    }

    Map __getfilenames() {
        if (!this.__Ffilenames) {
            return this.filenames;
        }
        return (Map)this.__IM.onGet((Object)this, "filenames");
    }

    void __setfilenames(Map map) {
        if (!this.__Ffilenames) {
            this.filenames = map;
            return;
        }
        this.__IM.onSet((Object)this, "filenames", (Object)map);
    }

    public ExampleCXF(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private ExampleCXF(InstanceManager _manager, BundleContext bundleContext) {
        super(bundleContext);
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(((Object)((Object)this)).getClass()));
        this.__setfilenames(new HashMap());
    }

    public void start() throws Throwable {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __start() throws Throwable {
        ServiceReference httpService = this.bundleContext.getServiceReference(HttpService.class.getName());
        if (httpService == null) {
            throw new NullPointerException("HttpService is not registered");
        }
        this.__sethttpPort((String)httpService.getProperty("org.osgi.service.http.port"));
        this.registryReplacements.put("http.port", this.__gethttpPort());
        File fileToHelloService = new File("target/fileToHelloService");
        fileToHelloService.mkdirs();
        String fileToHelloServicePath = fileToHelloService.getAbsolutePath().replace('\\', '/');
        this.registryReplacements.put("fileToHelloService", fileToHelloServicePath);
        super.start();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.test();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    public void configure() throws Exception {
        if (!this.__Mconfigure) {
            this.__configure();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configure", new Object[0]);
            this.__configure();
            this.__IM.onExit((Object)this, "configure", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configure", throwable);
            throw throwable;
        }
    }

    private void __configure() throws Exception {
        super.configure();
        this.from("registry:helloService").process(new Processor(){

            public void process(Exchange exchange) throws Exception {
                MessageContentsList msgList = (MessageContentsList)exchange.getIn().getBody(MessageContentsList.class);
                String name = (String)msgList.get(0);
                ExampleCXF.this.__getlogger().info((Object)("Received CXF message: " + name), new Object[0]);
                MessageContentsList response = new MessageContentsList();
                response.add((Object)("hello, " + name));
                exchange.getOut().setBody((Object)response);
            }
        });
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("registry:fileToHelloService_requests").process(new Processor(){

            public void process(Exchange exchange) throws Exception {
                ExampleCXF.this.__getfilenames().put(exchange.getExchangeId(), exchange.getIn().getHeader("CamelFileName", String.class));
                String message = (String)exchange.getIn().getBody(String.class);
                exchange.getOut().setHeader("operationName", (Object)"hello");
                MessageContentsList msgList = new MessageContentsList();
                msgList.add(0, (Object)message);
                exchange.getOut().setBody((Object)msgList);
            }
        })).to("registry:helloService")).process(new Processor(){

            public void process(Exchange exchange) throws Exception {
                String filename = (String)ExampleCXF.this.__getfilenames().remove(exchange.getExchangeId());
                exchange.getOut().setHeader("CamelFileName", (Object)filename);
                exchange.getOut().setBody(exchange.getIn().getBody());
            }
        })).to("registry:fileToHelloService_responses");
    }

    public void test() throws Exception {
        if (!this.__Mtest) {
            this.__test();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "test", new Object[0]);
            this.__test();
            this.__IM.onExit((Object)this, "test", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "test", throwable);
            throw throwable;
        }
    }

    private void __test() throws Exception {
        ClientProxyFactoryBean factory = new ClientProxyFactoryBean();
        factory.setServiceClass(ISayHello.class);
        factory.setAddress("http://localhost:" + this.__gethttpPort() + "/services/SayHello");
        ISayHello client = (ISayHello)factory.create();
        String response = client.hello("guillaume");
        this.__getlogger().info((Object)("Got CXF response: " + response), new Object[0]);
        File selfTestDir = new File("target/fileToHelloService/requests");
        selfTestDir.mkdirs();
        File selfTest = new File(selfTestDir, "selfTest.txt").getAbsoluteFile();
        FileOutputStream fo = new FileOutputStream(selfTest);
        fo.write("ali".getBytes());
        fo.close();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("filenames")) {
                this.__Ffilenames = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("httpPort")) {
                this.__FhttpPort = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("configure")) {
                this.__Mconfigure = true;
            }
            if (set.contains("test")) {
                this.__Mtest = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

