/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.component;

import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;

public class HttpClientProcessor
implements Processor {
    private String httpUrl;
    private String charset = "UTF-8";

    public HttpClientProcessor(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    public HttpClientProcessor(String httpUrl, String charset) {
        this.httpUrl = httpUrl;
        this.charset = charset;
    }

    public void process(Exchange exchange) throws Exception {
        StringBuilder urlBuilder = new StringBuilder(this.httpUrl);
        boolean appendQuestionMark = !this.httpUrl.contains("?");
        for (Map.Entry header : exchange.getIn().getHeaders().entrySet()) {
            appendQuestionMark = this.appendKeyValue(appendQuestionMark, urlBuilder, (String)header.getKey(), header.getValue());
        }
        URL httpUrl = new URL(urlBuilder.toString());
        HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection(Proxy.NO_PROXY);
        exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
        exchange.getOut().setBody((Object)connection.getInputStream());
    }

    private boolean appendKeyValue(boolean appendQuestionMark, StringBuilder urlBuilder, String key, Object value) throws Exception {
        if (value != null) {
            if (value instanceof String[]) {
                String[] valueStringArray;
                for (String valueString : valueStringArray = (String[])value) {
                    appendQuestionMark = this.appendKeyValue(appendQuestionMark, urlBuilder, key, valueString);
                }
            } else {
                if (appendQuestionMark) {
                    urlBuilder.append('?');
                    appendQuestionMark = false;
                } else {
                    urlBuilder.append('&');
                }
                urlBuilder.append(URLEncoder.encode(key, this.charset));
                urlBuilder.append('=');
                urlBuilder.append(URLEncoder.encode(value.toString(), this.charset));
            }
        }
        return appendQuestionMark;
    }
}

