/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.example.jms;

import java.io.InputStream;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.camel.service.api.ICamelService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.JndiDestinationResolver;

public class ExampleJMS
implements Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private Log logger;
    private boolean __FcamelService;
    private ICamelService camelService;
    private boolean __FcamelContextName;
    private String camelContextName;
    private boolean __Mstart;
    private boolean __Mtest;
    private boolean __Mstop;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    ICamelService __getcamelService() {
        if (!this.__FcamelService) {
            return this.camelService;
        }
        return (ICamelService)this.__IM.onGet((Object)this, "camelService");
    }

    void __setcamelService(ICamelService iCamelService) {
        if (!this.__FcamelService) {
            this.camelService = iCamelService;
            return;
        }
        this.__IM.onSet((Object)this, "camelService", (Object)iCamelService);
    }

    String __getcamelContextName() {
        if (!this.__FcamelContextName) {
            return this.camelContextName;
        }
        return (String)this.__IM.onGet((Object)this, "camelContextName");
    }

    void __setcamelContextName(String string) {
        if (!this.__FcamelContextName) {
            this.camelContextName = string;
            return;
        }
        this.__IM.onSet((Object)this, "camelContextName", (Object)string);
    }

    public ExampleJMS() {
        this(null);
    }

    private ExampleJMS(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(this.getClass()));
        this.__setcamelService(null);
        this.__setcamelContextName(null);
    }

    public void start() throws Throwable {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __start() throws Throwable {
        ClassLoader bundleCL = this.getClass().getClassLoader();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            RouteBuilder builder = new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("registry:queue").process(new Processor(){

                        public void process(Exchange e) {
                            ExampleJMS.this.__getlogger().info((Object)"Received JMS message {0}", new Object[]{e.getIn().getBody()});
                        }
                    });
                }
            };
            this.__setcamelContextName(this.__getcamelService().startNewContext());
            this.__getlogger().info((Object)"Camel context {0} started", new Object[]{this.__getcamelContextName()});
            InputStream input = bundleCL.getResourceAsStream("jms-registry.xml");
            this.__getcamelService().addRegistry(input, this.__getcamelContextName());
            try {
                Thread.currentThread().setContextClassLoader(bundleCL);
                JmsComponent joram = new JmsComponent();
                InitialContext context = new InitialContext();
                ConnectionFactory connectionFactory = (ConnectionFactory)context.lookup("CF");
                joram.setConnectionFactory(connectionFactory);
                JndiDestinationResolver jndiDestinationResolver = new JndiDestinationResolver();
                jndiDestinationResolver.setCache(true);
                joram.setDestinationResolver((DestinationResolver)jndiDestinationResolver);
                this.__getcamelService().addComponent("joram", (Component)joram, this.__getcamelContextName());
                this.__getlogger().debug((Object)"JORAM component added", new Object[0]);
                this.__getcamelService().addRoutes(builder, this.__getcamelContextName());
                this.test();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
        catch (Throwable t) {
            this.__getlogger().error((Object)"Cannot start ExampleJMS", new Object[]{t});
            throw t;
        }
    }

    public void test() throws Exception {
        if (!this.__Mtest) {
            this.__test();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "test", new Object[0]);
            this.__test();
            this.__IM.onExit((Object)this, "test", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "test", throwable);
            throw throwable;
        }
    }

    private void __test() throws Exception {
        InitialContext context = new InitialContext();
        QueueConnectionFactory connectionFactory = (QueueConnectionFactory)context.lookup("JQCF");
        QueueConnection queueConnection = connectionFactory.createQueueConnection();
        QueueSession queueSession = queueConnection.createQueueSession(false, 1);
        Queue queue = (Queue)context.lookup("sampleQueue");
        QueueSender jmsSender = queueSession.createSender(queue);
        for (int i = 0; i < 5; ++i) {
            TextMessage message = queueSession.createTextMessage("Test Message: " + i);
            jmsSender.send((Message)message);
        }
    }

    public void stop() throws Exception {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __stop() throws Exception {
        try {
            this.__getcamelService().stop(this.__getcamelContextName());
        }
        finally {
            this.__setcamelContextName(null);
            this.__setcamelService(null);
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("camelContextName")) {
                this.__FcamelContextName = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("camelService")) {
                this.__FcamelService = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("test")) {
                this.__Mtest = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

