/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.component;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.ow2.jonas.camel.service.api.ICamelService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryInjector {
    private static final String REGISTRY_PREFIX = "registry";
    private Map<String, String> replacements = new HashMap<String, String>();
    private File conf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryInjector(Map<String, String> replacements) throws Exception {
        String JONAS_BASE = System.getProperty("jonas.base");
        if (JONAS_BASE == null) {
            throw new RuntimeException("JONAS_BASE not defined");
        }
        this.conf = new File(JONAS_BASE, "conf").getAbsoluteFile();
        for (File file : this.conf.listFiles()) {
            String fileName = file.getName();
            if (!fileName.startsWith(REGISTRY_PREFIX) || !fileName.endsWith(".properties")) continue;
            FileInputStream is = new FileInputStream(file);
            try {
                Properties registryProperties = new Properties();
                registryProperties.load(is);
                for (Map.Entry<Object, Object> registryProperty : registryProperties.entrySet()) {
                    String key = (String)registryProperty.getKey();
                    String value = (String)registryProperty.getValue();
                    this.replacements.put(key, value);
                }
            }
            finally {
                ((InputStream)is).close();
                is = null;
                System.gc();
            }
        }
        if (replacements != null) {
            this.replacements.putAll(replacements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void injectRegistry(ICamelService camelService, String camelContextName) throws Exception {
        for (File file : this.conf.listFiles()) {
            String registryString;
            String fileName = file.getName();
            if (!fileName.startsWith(REGISTRY_PREFIX) || !fileName.endsWith(".xml")) continue;
            FileReader fr = new FileReader(file);
            try {
                BufferedReader br = new BufferedReader(fr);
                try {
                    String line;
                    StringBuilder sb = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                        sb.append('\n');
                    }
                    registryString = sb.toString();
                }
                finally {
                    br.close();
                    br = null;
                    System.gc();
                }
            }
            finally {
                fr.close();
                fr = null;
                System.gc();
            }
            for (Map.Entry<String, String> replacement : this.replacements.entrySet()) {
                registryString = registryString.replace("$" + replacement.getKey(), replacement.getValue());
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(registryString.getBytes());
            camelService.addRegistry((InputStream)bais, camelContextName);
        }
    }
}

