/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.component;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.RouteNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.TraceInterceptor;
import org.apache.camel.spi.TracedRouteNodes;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class MessageFormatter
implements TraceFormatter {
    private static Log logger = LogFactory.getLog(MessageFormatter.class);

    public Object format(TraceInterceptor interceptor, ProcessorDefinition node, Exchange exchange) {
        return MessageFormatter.formatMessage(exchange);
    }

    public static String formatMessage(Exchange exchange) {
        return MessageFormatter.formatMessage(exchange, null);
    }

    public static String formatMessage(Exchange exchange, Map<String, String> headers) {
        String id = exchange.getExchangeId();
        String from = "";
        String to = "";
        TracedRouteNodes tracedNode = exchange.getUnitOfWork().getTracedRouteNodes();
        RouteNode traceFrom = tracedNode.getSecondLastNode();
        if (traceFrom != null) {
            from = traceFrom.getLabel(exchange);
        } else if (exchange.getFromEndpoint() != null) {
            from = exchange.getFromEndpoint().getEndpointUri();
        }
        RouteNode traceTo = tracedNode.getLastNode();
        if (traceTo != null) {
            to = traceTo.getLabel(exchange);
        }
        Throwable exception = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
        String filename = null;
        if (exchange.hasOut()) {
            filename = (String)exchange.getOut().getHeader("CamelFileName", String.class);
        }
        if (filename == null) {
            filename = (String)exchange.getIn().getHeader("CamelFileName", String.class);
        }
        if (filename == null) {
            filename = "";
        }
        String filenameAbsolutePath = null;
        if (exchange.hasOut()) {
            filenameAbsolutePath = (String)exchange.getOut().getHeader("CamelFileAbsolutePath", String.class);
        }
        if (filenameAbsolutePath == null) {
            filenameAbsolutePath = (String)exchange.getIn().getHeader("CamelFileAbsolutePath", String.class);
        }
        if (filenameAbsolutePath == null) {
            filenameAbsolutePath = "";
        }
        return MessageFormatter.formatMessage(from, to, id, exception, filename, filenameAbsolutePath, headers);
    }

    public static String formatMessage(String from, String to, String exchangeId, Throwable exception, String filename, String filenameAbsolutePath) {
        return MessageFormatter.formatMessage(from, to, exchangeId, exception, filename, filenameAbsolutePath, null);
    }

    public static String formatMessage(String from, String to, String exchangeId, Throwable exception, String filename, String filenameAbsolutePath, Map<String, String> headers) {
        boolean headersGivenAsArgument;
        if (headers == null) {
            headersGivenAsArgument = false;
            headers = new LinkedHashMap<String, String>();
        } else {
            headersGivenAsArgument = true;
        }
        String filenameAbsoluteWithSlash = filenameAbsolutePath;
        if (filenameAbsoluteWithSlash.contains("\\")) {
            filenameAbsoluteWithSlash = filenameAbsoluteWithSlash.replace("\\", "/");
        }
        if (!filenameAbsoluteWithSlash.startsWith("/")) {
            filenameAbsoluteWithSlash = "/" + filenameAbsoluteWithSlash;
        }
        if (exchangeId != null) {
            headers.put("MessageId", exchangeId);
        }
        headers.put("From", MessageFormatter.filterParameters(from));
        headers.put("To", MessageFormatter.filterParameters(to));
        headers.put("FileName", filename);
        headers.put("FileNameAbsolute", filenameAbsoluteWithSlash);
        if (exception != null) {
            headers.put("HasException", Boolean.TRUE.toString());
            headers.put("ExceptionClass", exception.getClass().getName());
            if (headersGivenAsArgument) {
                headers.put("ExceptionMessage", exception.getMessage());
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                headers.put("ExceptionStackTrace", sw.toString());
            } else if (exception.getMessage() == null) {
                headers.put("ExceptionMessage", "");
            } else {
                try {
                    headers.put("ExceptionMessage", URLEncoder.encode(exception.getMessage(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    logger.error((Object)"Cannot format message", new Object[]{e});
                    headers.put("ExceptionMessage", "");
                }
            }
        } else {
            headers.put("HasException", Boolean.FALSE.toString());
        }
        return headers.toString();
    }

    public static String filterParameters(String url) {
        if (url == null) {
            return null;
        }
        int questionMark = url.indexOf(63);
        if (questionMark == -1) {
            return url;
        }
        return url.substring(0, questionMark);
    }
}

