/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.component;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.ow2.jonas.camel.service.api.ICamelService;

public class RegistryInjector {
    private static final String REGISTRY_PREFIX = "registry";
    private static final String REGISTRY_CAMEL_FILE_NAME = "registry-camel.xml";
    private Map<String, String> replacements = new HashMap<String, String>();
    private File conf;
    private List<String> registryFilesContent;

    public RegistryInjector() throws Exception {
        this(null, null);
    }

    public RegistryInjector(Map<String, String> extraReplacements) throws Exception {
        this(extraReplacements, null);
    }

    public RegistryInjector(List<String> includeXMLs) throws Exception {
        this(null, includeXMLs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryInjector(Map<String, String> extraReplacements, List<String> includeXMLs) throws Exception {
        String fileName;
        String JONAS_BASE = System.getProperty("jonas.base");
        if (JONAS_BASE == null) {
            throw new RuntimeException("JONAS_BASE not defined");
        }
        this.conf = new File(JONAS_BASE, "conf").getAbsoluteFile();
        for (File file : this.conf.listFiles()) {
            fileName = file.getName();
            if (!fileName.startsWith(REGISTRY_PREFIX) || !fileName.endsWith(".properties")) continue;
            FileInputStream is = new FileInputStream(file);
            try {
                Properties registryProperties = new Properties();
                registryProperties.load(is);
                for (Map.Entry<Object, Object> entry : registryProperties.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    this.replacements.put(key, value);
                }
            }
            finally {
                ((InputStream)is).close();
                is = null;
            }
        }
        if (extraReplacements != null) {
            this.replacements.putAll(extraReplacements);
        }
        this.registryFilesContent = new ArrayList<String>();
        if (null != this.getClass().getResourceAsStream(REGISTRY_CAMEL_FILE_NAME)) {
            InputStreamReader isr = new InputStreamReader(this.getClass().getResourceAsStream(REGISTRY_CAMEL_FILE_NAME));
            String str = this.readBufferedReaderToString(new BufferedReader(isr));
            this.registryFilesContent.add(str);
        }
        for (File file : this.conf.listFiles()) {
            String registryString;
            fileName = file.getName();
            if (!fileName.startsWith(REGISTRY_PREFIX) || !fileName.endsWith(".xml") || includeXMLs != null && !includeXMLs.contains(fileName)) continue;
            FileReader fr = new FileReader(file);
            try {
                BufferedReader br = new BufferedReader(fr);
                registryString = this.readBufferedReaderToString(br);
            }
            finally {
                fr.close();
                fr = null;
            }
            for (Map.Entry<Object, Object> entry : this.replacements.entrySet()) {
                if (entry.getValue() == null) continue;
                registryString = registryString.replace("$" + (String)entry.getKey(), (CharSequence)entry.getValue());
            }
            this.registryFilesContent.add(registryString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readBufferedReaderToString(BufferedReader br) throws IOException {
        String registryString;
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
            registryString = sb.toString();
        }
        finally {
            br.close();
            br = null;
        }
        return registryString;
    }

    public Map<String, String> getAllReplacements() {
        return this.replacements;
    }

    public List<String> getRegistryFilesContent() {
        return this.registryFilesContent;
    }

    public void injectRegistry(ICamelService camelService, String camelContextName) throws Exception {
        for (String registryString : this.registryFilesContent) {
            ByteArrayInputStream bais = new ByteArrayInputStream(registryString.getBytes());
            camelService.addRegistry((InputStream)bais, camelContextName);
        }
    }
}

