/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.example.jms;

import java.io.File;
import java.util.Set;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.BundleContext;
import org.ow2.jonas.camel.component.RouteBuilderComponent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ExampleJMS
extends RouteBuilderComponent
implements Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private Log logger;
    private boolean __FjonasLogs;
    private File jonasLogs;
    private boolean __Mstart;
    private boolean __Mconfigure;
    private boolean __Mtest;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    File __getjonasLogs() {
        if (!this.__FjonasLogs) {
            return this.jonasLogs;
        }
        return (File)this.__IM.onGet((Object)this, "jonasLogs");
    }

    void __setjonasLogs(File file) {
        if (!this.__FjonasLogs) {
            this.jonasLogs = file;
            return;
        }
        this.__IM.onSet((Object)this, "jonasLogs", (Object)file);
    }

    public ExampleJMS(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private ExampleJMS(InstanceManager _manager, BundleContext bundleContext) {
        super(bundleContext);
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(((Object)((Object)this)).getClass()));
    }

    @Override
    public void start() throws Throwable {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __start() throws Throwable {
        String jonasBase = System.getProperty("jonas.base");
        if (jonasBase == null) {
            throw new IllegalStateException("jonas.base is not set!");
        }
        File jonasBaseFile = new File(jonasBase);
        if (!jonasBaseFile.isDirectory()) {
            throw new IllegalStateException(jonasBaseFile + " is not a directory");
        }
        this.__setjonasLogs(new File(jonasBaseFile, "logs"));
        if (!this.__getjonasLogs().isDirectory()) {
            throw new IllegalStateException(this.__getjonasLogs() + " is not a directory");
        }
        super.start();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.test();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    @Override
    public void configure() throws Exception {
        if (!this.__Mconfigure) {
            this.__configure();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configure", new Object[0]);
            this.__configure();
            this.__IM.onExit((Object)this, "configure", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configure", throwable);
            throw throwable;
        }
    }

    private void __configure() throws Exception {
        this.from("registry:queue").process(new Processor(){

            public void process(Exchange e) throws Exception {
                String message = (String)e.getIn().getBody(String.class);
                ExampleJMS.this.__getlogger().info((Object)("Received JMS message: " + message), new Object[0]);
                File log = new File(ExampleJMS.this.__getjonasLogs(), message);
                log.createNewFile();
            }
        });
    }

    public void test() throws Exception {
        if (!this.__Mtest) {
            this.__test();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "test", new Object[0]);
            this.__test();
            this.__IM.onExit((Object)this, "test", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "test", throwable);
            throw throwable;
        }
    }

    private void __test() throws Exception {
        InitialContext context = new InitialContext();
        QueueConnectionFactory connectionFactory = (QueueConnectionFactory)context.lookup("JQCF");
        QueueConnection queueConnection = connectionFactory.createQueueConnection();
        QueueSession queueSession = queueConnection.createQueueSession(false, 1);
        Queue queue = (Queue)context.lookup("sampleQueue");
        QueueSender jmsSender = queueSession.createSender(queue);
        TextMessage message = queueSession.createTextMessage("Test Message");
        jmsSender.send((Message)message);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("jonasLogs")) {
                this.__FjonasLogs = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("configure")) {
                this.__Mconfigure = true;
            }
            if (set.contains("test")) {
                this.__Mtest = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

