/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.component;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;

public class CamelServlet
implements Servlet {
    private CamelContext camelContext;
    private String camelDestination;
    private ServletConfig servletConfig;
    private String defaultFileName;
    public static final String ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    public static final String REQUEST_PROPERTY_NAME = "REQUEST property";

    public CamelServlet(CamelContext camelContext, String camelDestination, String defaultFileName) {
        this.camelContext = camelContext;
        this.camelDestination = camelDestination;
        this.defaultFileName = defaultFileName;
    }

    public CamelServlet(CamelContext camelContext, String camelDestination) {
        this(camelContext, camelDestination, null);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void service(ServletRequest request, ServletResponse rsp) throws ServletException, IOException {
        block21: {
            ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                HttpServletResponse response = (HttpServletResponse)rsp;
                Producer producer = this.camelContext.getEndpoint(this.camelDestination).createProducer();
                Exchange exchange = producer.createExchange();
                exchange.getIn().getHeaders().putAll(request.getParameterMap());
                if (null != request.getContentType()) {
                    exchange.getIn().setHeader("Content-Type", (Object)request.getContentType());
                }
                exchange.getIn().setHeader("Content-Length", (Object)request.getContentLength());
                exchange.getIn().setBody((Object)request.getInputStream());
                exchange.setProperty(REQUEST_PROPERTY_NAME, (Object)request);
                producer.process(exchange);
                this.checkHeaders(exchange, response);
                Throwable exception = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
                if (exception != null) {
                    throw exception;
                }
                String filename = (String)exchange.getOut().getHeader("CamelFileName", String.class);
                if (filename == null) {
                    filename = (String)exchange.getIn().getHeader("CamelFileName", String.class);
                }
                if (filename == null) {
                    filename = this.defaultFileName;
                }
                if (filename != null) {
                    filename = URLEncoder.encode(filename);
                    response.setHeader("Content-Type", "application/force-download; name=\"" + filename + "\"");
                    response.setHeader("Content-Transfer-Encoding", "binary");
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
                }
                if (exchange.getOut().getBody() == null) {
                    return;
                }
                Object bodyString = exchange.getOut().getBody();
                if (bodyString instanceof String) {
                    response.getWriter().write((String)bodyString);
                    return;
                }
                InputStream bodyStream = (InputStream)exchange.getOut().getBody(InputStream.class);
                if (bodyStream != null) {
                    try {
                        int read;
                        while ((read = bodyStream.read()) != -1) {
                            response.getOutputStream().write(read);
                        }
                    }
                    catch (Throwable throwable) {
                        bodyStream.close();
                        Thread.currentThread().setContextClassLoader(oldTCCL);
                        return;
                    }
                    bodyStream.close();
                    return;
                }
                byte[] bodyByteArray = (byte[])exchange.getOut().getBody(byte[].class);
                if (bodyByteArray == null) {
                    throw new NullPointerException("Request body is not a String, InputStream or byte array: " + exchange.getOut().getBody().getClass());
                }
                response.getOutputStream().write(bodyByteArray);
                break block21;
                {
                    catch (Throwable t) {
                        throw new ServletException("CAMEL process failed: " + t.getMessage(), t);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldTCCL);
            }
        }
    }

    public String getServletInfo() {
        return this.toString();
    }

    public void destroy() {
    }

    private void checkHeaders(Exchange exchangeMessage, HttpServletResponse response) {
        Integer errorCode = (Integer)exchangeMessage.getOut().getHeader(ERROR_STATUS_CODE, Integer.class);
        if (null != errorCode) {
            response.setStatus(errorCode.intValue());
        }
    }
}

