/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.example.servlet;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.ow2.jonas.camel.component.CamelServlet;
import org.ow2.jonas.camel.component.RouteBuilderComponent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ExampleCamelServlet
extends RouteBuilderComponent
implements Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private Log logger;
    public static final String SERVLET_PATH = "/camelServlet";
    public static final String SERVLET_ENDPOINT = "direct:fromServlet";
    private boolean __Mstart;
    private boolean __Mconfigure;
    private boolean __MgetService$java_lang_Class;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    public ExampleCamelServlet(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private ExampleCamelServlet(InstanceManager _manager, BundleContext bundleContext) {
        super(bundleContext);
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(ExampleCamelServlet.class));
    }

    @Override
    public void start() throws Throwable {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() throws Throwable {
        super.start();
        HttpService httpService = this.getService(HttpService.class);
        HttpContext httpContext = httpService.createDefaultHttpContext();
        Hashtable<String, String> initParams = new Hashtable<String, String>();
        ((Dictionary)initParams).put("matchOnUriPrefix", "false");
        ((Dictionary)initParams).put("servlet-name", SERVLET_PATH);
        httpService.registerServlet(SERVLET_PATH, (Servlet)new CamelServlet((CamelContext)this.getContext(), SERVLET_ENDPOINT), initParams, httpContext);
    }

    @Override
    public void configure() throws Exception {
        if (!this.__Mconfigure) {
            this.__configure();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configure", new Object[0]);
            this.__configure();
            this.__IM.onExit((Object)this, "configure", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configure", throwable);
            throw throwable;
        }
    }

    private void __configure() throws Exception {
        super.configure();
        this.from(SERVLET_ENDPOINT).process(new Processor(){

            public void process(Exchange exchange) throws Exception {
                ServletRequest request = (ServletRequest)exchange.getProperty("REQUEST property", ServletRequest.class);
                ExampleCamelServlet.this.__getlogger().info((Object)"The request content length property of the servlet request is {0}", new Object[]{request.getContentLength()});
                exchange.getOut().setBody((Object)"Hello from the CamelServlet endpoint... Thanks for using JOnAS/Camel");
            }
        });
    }

    private <T> T getService(Class<T> clazz) {
        T t;
        if (!this.__MgetService$java_lang_Class) {
            return this.__getService(clazz);
        }
        try {
            this.__IM.onEntry((Object)this, "getService$java_lang_Class", new Object[]{clazz});
            t = this.__getService(clazz);
            this.__IM.onExit((Object)this, "getService$java_lang_Class", t);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getService$java_lang_Class", throwable);
            throw throwable;
        }
        return t;
    }

    private <T> T __getService(Class<T> serviceType) {
        Object service;
        String serviceName = serviceType.getName();
        ServiceReference serviceReference = this.bundleContext.getServiceReference(serviceName);
        if (serviceReference != null && (service = this.bundleContext.getService(serviceReference)) != null) {
            if (!serviceType.isInstance(service)) {
                throw new IllegalStateException("OSGi service " + service + " not instance of " + serviceName);
            }
            return (T)service;
        }
        throw new IllegalStateException("Cannot find OSGi service " + serviceName);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("logger")) {
            this.__Flogger = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("configure")) {
                this.__Mconfigure = true;
            }
            if (set.contains("getService$java_lang_Class")) {
                this.__MgetService$java_lang_Class = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

