/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.test;

import java.util.Dictionary;
import java.util.Properties;
import junit.framework.Assert;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.cxf.Bus;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.message.MessageContentsList;
import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.http.HttpService;
import org.ow2.jonas.camel.test.ISayHello;
import org.ow2.jonas.samples.camel.service.api.ICamelService;

public class CamelCxfTest
extends OSGiTestCase {
    private static int SLEEP_TIME = 10;
    private static String cxfContext = "/services";
    private static int port = 17852;
    private static String busName = "cxfBusName";

    public void testCXF() throws Throwable {
        BundleContext bundleContext = this.getBundleContext();
        ServiceReference ref3 = bundleContext.getServiceReference(HttpService.class.getName());
        Assert.assertNotNull((String)"Assert http service availability", (Object)ref3);
        ServiceReference configurationAdminReference = bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        Assert.assertNotNull((String)"Assert configadmin availability", (Object)configurationAdminReference);
        ConfigurationAdmin confAdmin = (ConfigurationAdmin)bundleContext.getService(configurationAdminReference);
        Configuration configuration = confAdmin.createFactoryConfiguration("org.ow2.jonas.camel.cxf.servlet.OsgiCXFServletDeployer", null);
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Properties properties = new Properties();
            properties.setProperty("servletPath", cxfContext);
            properties.setProperty("busName", busName);
            configuration.update((Dictionary)properties);
            long stopTime = System.currentTimeMillis() + (long)(SLEEP_TIME * 1000);
            while (bundleContext.getServiceReference(Bus.class.getName()) == null && System.currentTimeMillis() < stopTime) {
                Thread.sleep(1000L);
            }
            ServiceReference ref2 = bundleContext.getServiceReference(Bus.class.getName());
            Assert.assertNotNull((String)"Assert bus availability", (Object)ref2);
            ServiceReference ref = bundleContext.getServiceReference(ICamelService.class.getName());
            Assert.assertNotNull((String)"Assert availability", (Object)ref);
            ICamelService service = (ICamelService)bundleContext.getService(ref);
            Assert.assertNotNull((String)"Assert instance", (Object)service);
            String contextname = service.startNewContext();
            Assert.assertNotNull((String)"Assert that a new camel context is created", (Object)contextname);
            RouteBuilder builder = new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("cxf://http://localhost:" + port + cxfContext + "/SayHello?" + "serviceClass=org.ow2.jonas.camel.test.ISayHello&dataFormat=POJO&" + "bus=#" + busName).process(new Processor(){

                        public void process(Exchange exchange) throws Exception {
                            MessageContentsList msgList = (MessageContentsList)exchange.getIn().getBody();
                            String name = (String)msgList.get(0);
                            msgList.clear();
                            msgList.add((Object)("coucou " + name));
                            exchange.setOut(exchange.getIn().copy());
                        }
                    });
                }
            };
            service.addComponent("cxf", (Component)new CxfComponent(), contextname);
            service.addRoutes(builder, contextname);
            ClientProxyFactoryBean factory = new ClientProxyFactoryBean();
            factory.setServiceClass(ISayHello.class);
            factory.setAddress("http://localhost:" + port + cxfContext + "/SayHello");
            ISayHello client = (ISayHello)factory.create();
            String res = client.hello("guillaume");
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((String)"coucou guillaume", (String)res);
            service.stop(contextname);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
            configuration.delete();
        }
    }
}

