/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.test;

import java.io.File;
import javax.jms.ConnectionFactory;
import junit.framework.Assert;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.camel.Component;
import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.ow2.jonas.samples.camel.service.api.ICamelService;

public class CamelJmsTest
extends OSGiTestCase {
    private static int TIME_OUT = 10;

    public void testJMSToFile() throws Exception {
        String message = "Test Message";
        final File target = new File("target/jms-test");
        target.mkdirs();
        BundleContext bundleContext = this.getBundleContext();
        ServiceReference ref = bundleContext.getServiceReference(ICamelService.class.getName());
        Assert.assertNotNull((String)"Assert availability", (Object)ref);
        ICamelService service = (ICamelService)bundleContext.getService(ref);
        Assert.assertNotNull((String)"Assert instance", (Object)service);
        String contextname = service.startNewContext();
        Assert.assertNotNull((String)"Assert that a new camel context is created", (Object)contextname);
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        service.addComponent("test-jms", (Component)JmsComponent.jmsComponentAutoAcknowledge((ConnectionFactory)connectionFactory), contextname);
        RouteBuilder builder = new RouteBuilder(){

            public void configure() throws Exception {
                this.from("test-jms:queue:Queue").setHeader("CamelFileName", (Expression)this.constant("report.txt")).to(target.toURL().toString());
            }
        };
        service.addRoutes(builder, contextname);
        ProducerTemplate template = service.getProducerTemplate(contextname);
        template.sendBody("test-jms:queue:Queue", (Object)"Test Message");
        File result = new File(target, "report.txt");
        long stopTime = System.currentTimeMillis() + (long)(TIME_OUT * 1000);
        while (!result.exists() && System.currentTimeMillis() < stopTime) {
            Thread.sleep(1000L);
        }
        Assert.assertTrue((String)"Assert that the file is correctly created", (boolean)result.exists());
        result.delete();
        service.stop(contextname);
    }
}

