/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CxfTest.java 18281 2009-08-17 18:20:43Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.example.cxf.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.apache.commons.io.FileUtils;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.jonas.camel.example.cxf.webservice.api.ISayHello;

public class CxfTest {

    private static int TIMEOUT = 30;

    private File deploy;

    private File bundle;

    private int port;

    @Before
    public void setUp() throws Exception {
        // deploy the bundle
        String jonasBase = System.getProperty("jonas.base");
        Assert.assertNotNull("jonas.base is not set!", jonasBase);
        this.deploy = new File(jonasBase, "deploy");
        Assert.assertTrue(this.deploy + " is not a directory!", this.deploy.isDirectory());

        String cxfExamplePath = System.getProperty("example-cxf.path");
        Assert.assertNotNull("example-cxf.path is not set!", cxfExamplePath);
        this.bundle = new File(cxfExamplePath);
        Assert.assertTrue(cxfExamplePath + " is not a file!", this.bundle.isFile());

        String webcontainerPort = System.getProperty("webcontainer.port");
        Assert.assertNotNull("webcontainer.port is not set!", webcontainerPort);
        this.port = Integer.parseInt(webcontainerPort);
    }

    @Test
    public void testDeployCXFExample() throws Exception {
        FileUtils.copyFileToDirectory(this.bundle, this.deploy);

        // wait for the WS to get deployed
        String remoteContent = "";
        final long stopTime = System.currentTimeMillis() + CxfTest.TIMEOUT * 1000;
        final URL remoteURL = new URL("http://localhost:" + this.port + "/services/SayHello?wsdl");
        while (System.currentTimeMillis() < stopTime) {
            Thread.sleep(1000);
            remoteContent = this.getContentAsString(remoteURL);
            if (remoteContent.contains("http://schemas.xmlsoap.org/wsdl/")) {
                return;
            }
        }

        Assert.fail("did not receive any wsdl! content was:\n" + remoteContent);
    }

    @Test
    public void testCXFExampleRoute() throws Exception {
        ClientProxyFactoryBean factory = new ClientProxyFactoryBean();
        factory.setServiceClass(ISayHello.class);
        factory.setAddress("http://localhost:" + this.port + "/services/SayHello");
        ISayHello client = (ISayHello) factory.create();

        String response = client.hello("guillaume");
        Assert.assertEquals("hello, guillaume", response);
    }

    private String getContentAsString(final URL url) {
        try {
            final InputStream inStream = url.openStream();
            final ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                int c;
                while ((c = inStream.read()) != -1) {
                    bos.write(c);
                }
            } finally {
                inStream.close();
                bos.flush();
            }
            final String urlString = bos.toString();
            return urlString;
        } catch (IOException e) {
            return e.toString();
        }
    }
}
