/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JmsTest.java 18284 2009-08-17 19:01:41Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.example.jms.test;

import java.io.File;

import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JmsTest {

    private static int TIMEOUT = 20;

    private File deploy;

    private File bundle;

    @Before
    public void setUp() throws Exception {
        // deploy the bundle
        String jonasBase = System.getProperty("jonas.base");
        Assert.assertNotNull("jonas.base is not set!", jonasBase);
        this.deploy = new File(jonasBase, "deploy");
        Assert.assertTrue(this.deploy + " is not a directory!", this.deploy.isDirectory());

        String jmsExamplePath = System.getProperty("example-jms.path");
        Assert.assertNotNull("example-jms.path is not set!", jmsExamplePath);
        this.bundle = new File(jmsExamplePath);
        Assert.assertTrue(jmsExamplePath + " is not a file!", this.bundle.isFile());
    }

    @Test
    public void testDeployJMSExample() throws Exception {
        FileUtils.copyFileToDirectory(this.bundle, this.deploy);

        // TODO: test it somehow?
        Thread.sleep(JmsTest.TIMEOUT * 1000);
    }
}
