/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.service.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.configuration.DeploymentPlanDeployer;
import org.ow2.jonas.depmonitor.MonitoringService;
import org.ow2.jonas.lib.management.javaee.J2EEServiceState;
import org.ow2.jonas.lib.service.manager.DeployableEnumeration;
import org.ow2.jonas.lib.service.manager.RequireJOnASServicesHandler;
import org.ow2.jonas.lib.service.manager.ServiceItem;
import org.ow2.jonas.lib.service.manager.ServiceTracker;
import org.ow2.jonas.lib.service.manager.ServiceUtil;
import org.ow2.jonas.management.J2EEServerService;
import org.ow2.jonas.management.ServiceManager;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.util.archive.api.IArchiveMetadata;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManagerCallback;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagerImpl
implements ServiceManager,
Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private Log logger;
    private boolean __FserviceItems;
    private List<ServiceItem> serviceItems;
    private boolean __FbundleContext;
    private BundleContext bundleContext;
    private boolean __FconfigurationManager;
    private ConfigurationManager configurationManager;
    private boolean __Fj2eeServer;
    private J2EEServerService j2eeServer;
    private boolean __FdeployerManager;
    private IDeployerManager deployerManager;
    private boolean __FdeploymentPlanDeployer;
    private DeploymentPlanDeployer deploymentPlanDeployer;
    private boolean __FdeployerManagerCallback;
    private IDeployerManagerCallback deployerManagerCallback;
    private boolean __FserverProperties;
    private ServerProperties serverProperties;
    private static final String JONAS_STANDBY = "jonas.standby";
    private static final String REQUIRE_JONAS_SERVICES = "Require-JOnAS-Services";
    private static final String JPA_PROVIDER = "jpa.provider";
    private static final String EASYBANS_PREFIX_SYMBOLIC_NAME = "org.ow2.easybeans.core.for.jonas.";
    private static final int WAITING_TIME = 20000;
    private static final int SERVICE_REGISTRATION_TIMEOUT = 10000;
    private boolean __FcheckServiceStates;
    private boolean checkServiceStates;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MaddServiceItem$org_ow2_jonas_lib_service_manager_ServiceItem;
    private boolean __MdeleteAllServiceItems;
    private boolean __MgetAllServices;
    private boolean __MgetOptionalServices;
    private boolean __MsetServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState;
    private boolean __MgetServiceState$java_lang_String;
    private boolean __MgetServiceDescription$java_lang_String;
    private boolean __MgetNonRunningServices;
    private boolean __MallOptionalServicesStopped;
    private boolean __McheckServerState$java_lang_String;
    private boolean __MstartMonitoring;
    private boolean __MdepMonitorRunning;
    private boolean __MdepMonitorReference;
    private boolean __MstartService$java_lang_String;
    private boolean __MstartService$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel;
    private boolean __MstartRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __MstopService$java_lang_String;
    private boolean __MstartServices;
    private boolean __MstartServices$boolean;
    private boolean __MstopServices;
    private boolean __McreateServiceItem$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel;
    private boolean __McreateServiceItem$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel$org_ow2_jonas_lib_management_javaee_J2EEServiceState;
    private boolean __MbindJ2EEServer$org_ow2_jonas_management_J2EEServerService;
    private boolean __MunbindJ2EEServer$org_ow2_jonas_management_J2EEServerService;
    private boolean __MsetConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager;
    private boolean __MsetDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager;
    private boolean __MsetDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer;
    private boolean __MsetServerProperties$org_ow2_jonas_properties_ServerProperties;
    private boolean __MdisableServiceStatesCheck;
    private boolean __MupdateServiceItems;
    private boolean __MupdateServiceItems$boolean;
    private boolean __MconvertToList$java_lang_String;
    private boolean __McheckServiceStates;
    private boolean __MdeployEasyBeans;
    private boolean __MwaitForServiceRegistration$java_lang_String;
    private boolean __MisServiceStarted$java_lang_String;
    private boolean __MisServiceStopped$java_lang_String;
    private boolean __MgetServiceItem$java_lang_String;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    List __getserviceItems() {
        if (!this.__FserviceItems) {
            return this.serviceItems;
        }
        return (List)this.__IM.onGet((Object)this, "serviceItems");
    }

    void __setserviceItems(List list) {
        if (!this.__FserviceItems) {
            this.serviceItems = list;
            return;
        }
        this.__IM.onSet((Object)this, "serviceItems", (Object)list);
    }

    BundleContext __getbundleContext() {
        if (!this.__FbundleContext) {
            return this.bundleContext;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "bundleContext");
    }

    void __setbundleContext(BundleContext bundleContext) {
        if (!this.__FbundleContext) {
            this.bundleContext = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "bundleContext", (Object)bundleContext);
    }

    ConfigurationManager __getconfigurationManager() {
        if (!this.__FconfigurationManager) {
            return this.configurationManager;
        }
        return (ConfigurationManager)this.__IM.onGet((Object)this, "configurationManager");
    }

    void __setconfigurationManager(ConfigurationManager configurationManager) {
        if (!this.__FconfigurationManager) {
            this.configurationManager = configurationManager;
            return;
        }
        this.__IM.onSet((Object)this, "configurationManager", (Object)configurationManager);
    }

    J2EEServerService __getj2eeServer() {
        if (!this.__Fj2eeServer) {
            return this.j2eeServer;
        }
        return (J2EEServerService)this.__IM.onGet((Object)this, "j2eeServer");
    }

    void __setj2eeServer(J2EEServerService j2EEServerService) {
        if (!this.__Fj2eeServer) {
            this.j2eeServer = j2EEServerService;
            return;
        }
        this.__IM.onSet((Object)this, "j2eeServer", (Object)j2EEServerService);
    }

    IDeployerManager __getdeployerManager() {
        if (!this.__FdeployerManager) {
            return this.deployerManager;
        }
        return (IDeployerManager)this.__IM.onGet((Object)this, "deployerManager");
    }

    void __setdeployerManager(IDeployerManager iDeployerManager) {
        if (!this.__FdeployerManager) {
            this.deployerManager = iDeployerManager;
            return;
        }
        this.__IM.onSet((Object)this, "deployerManager", (Object)iDeployerManager);
    }

    DeploymentPlanDeployer __getdeploymentPlanDeployer() {
        if (!this.__FdeploymentPlanDeployer) {
            return this.deploymentPlanDeployer;
        }
        return (DeploymentPlanDeployer)this.__IM.onGet((Object)this, "deploymentPlanDeployer");
    }

    void __setdeploymentPlanDeployer(DeploymentPlanDeployer deploymentPlanDeployer) {
        if (!this.__FdeploymentPlanDeployer) {
            this.deploymentPlanDeployer = deploymentPlanDeployer;
            return;
        }
        this.__IM.onSet((Object)this, "deploymentPlanDeployer", (Object)deploymentPlanDeployer);
    }

    IDeployerManagerCallback __getdeployerManagerCallback() {
        if (!this.__FdeployerManagerCallback) {
            return this.deployerManagerCallback;
        }
        return (IDeployerManagerCallback)this.__IM.onGet((Object)this, "deployerManagerCallback");
    }

    void __setdeployerManagerCallback(IDeployerManagerCallback iDeployerManagerCallback) {
        if (!this.__FdeployerManagerCallback) {
            this.deployerManagerCallback = iDeployerManagerCallback;
            return;
        }
        this.__IM.onSet((Object)this, "deployerManagerCallback", (Object)iDeployerManagerCallback);
    }

    ServerProperties __getserverProperties() {
        if (!this.__FserverProperties) {
            return this.serverProperties;
        }
        return (ServerProperties)this.__IM.onGet((Object)this, "serverProperties");
    }

    void __setserverProperties(ServerProperties serverProperties) {
        if (!this.__FserverProperties) {
            this.serverProperties = serverProperties;
            return;
        }
        this.__IM.onSet((Object)this, "serverProperties", (Object)serverProperties);
    }

    boolean __getcheckServiceStates() {
        if (!this.__FcheckServiceStates) {
            return this.checkServiceStates;
        }
        Object object = this.__IM.onGet((Object)this, "checkServiceStates");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setcheckServiceStates(boolean bl) {
        if (!this.__FcheckServiceStates) {
            this.checkServiceStates = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "checkServiceStates", (Object)bl2);
    }

    public ServiceManagerImpl(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private ServiceManagerImpl(InstanceManager _manager, BundleContext bc) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(J2EEServerService.class));
        this.__setserviceItems(null);
        this.__setconfigurationManager(null);
        this.__setj2eeServer(null);
        this.__setdeployerManager(null);
        this.__setdeploymentPlanDeployer(null);
        this.__setdeployerManagerCallback(null);
        this.__setserverProperties(null);
        this.__setcheckServiceStates(false);
        this.__setbundleContext(bc);
        this.__setserviceItems(new ArrayList());
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() {
        this.__setdeployerManagerCallback(new RequireJOnASServicesHandler(this));
        this.__getdeployerManager().addCallback(this.__getdeployerManagerCallback());
        this.updateServiceItems(true);
        if (this.getAllServices().contains("discovery")) {
            try {
                this.startService("discovery", ServiceItem.ServiceLevel.MANDATORY);
            }
            catch (Exception e) {
                this.__getlogger().error((Object)"Cannot start the discovery service", new Object[]{e});
            }
        }
        if (!Boolean.getBoolean(JONAS_STANDBY)) {
            this.startServices(false);
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() {
        this.__getdeployerManager().removeCallback(this.__getdeployerManagerCallback());
    }

    private void addServiceItem(ServiceItem serviceItem) {
        if (!this.__MaddServiceItem$org_ow2_jonas_lib_service_manager_ServiceItem) {
            this.__addServiceItem(serviceItem);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addServiceItem$org_ow2_jonas_lib_service_manager_ServiceItem", new Object[]{serviceItem});
            this.__addServiceItem(serviceItem);
            this.__IM.onExit((Object)this, "addServiceItem$org_ow2_jonas_lib_service_manager_ServiceItem", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addServiceItem$org_ow2_jonas_lib_service_manager_ServiceItem", throwable);
            throw throwable;
        }
    }

    private void __addServiceItem(ServiceItem serviceItem) {
        this.__getserviceItems().add(serviceItem);
    }

    private void deleteAllServiceItems() {
        if (!this.__MdeleteAllServiceItems) {
            this.__deleteAllServiceItems();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deleteAllServiceItems", new Object[0]);
            this.__deleteAllServiceItems();
            this.__IM.onExit((Object)this, "deleteAllServiceItems", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deleteAllServiceItems", throwable);
            throw throwable;
        }
    }

    private void __deleteAllServiceItems() {
        this.__getserviceItems().clear();
    }

    public List<String> getAllServices() {
        List<String> list;
        if (!this.__MgetAllServices) {
            return this.__getAllServices();
        }
        try {
            this.__IM.onEntry((Object)this, "getAllServices", new Object[0]);
            list = this.__getAllServices();
            this.__IM.onExit((Object)this, "getAllServices", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAllServices", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getAllServices() {
        ArrayList<String> result = new ArrayList<String>();
        for (ServiceItem serviceItem : this.__getserviceItems()) {
            result.add(serviceItem.getName());
        }
        return result;
    }

    public List<String> getOptionalServices() {
        List<String> list;
        if (!this.__MgetOptionalServices) {
            return this.__getOptionalServices();
        }
        try {
            this.__IM.onEntry((Object)this, "getOptionalServices", new Object[0]);
            list = this.__getOptionalServices();
            this.__IM.onExit((Object)this, "getOptionalServices", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOptionalServices", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getOptionalServices() {
        ArrayList<String> result = new ArrayList<String>();
        for (ServiceItem serviceItem : this.__getserviceItems()) {
            if (serviceItem.getServiceLevel() == ServiceItem.ServiceLevel.MANDATORY) continue;
            result.add(serviceItem.getName());
        }
        return result;
    }

    public J2EEServiceState setServiceState(String string, J2EEServiceState j2EEServiceState) {
        J2EEServiceState j2EEServiceState2;
        if (!this.__MsetServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState) {
            return this.__setServiceState(string, j2EEServiceState);
        }
        try {
            this.__IM.onEntry((Object)this, "setServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState", new Object[]{string, j2EEServiceState});
            j2EEServiceState2 = this.__setServiceState(string, j2EEServiceState);
            this.__IM.onExit((Object)this, "setServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState", (Object)j2EEServiceState2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState", throwable);
            throw throwable;
        }
        return j2EEServiceState2;
    }

    private J2EEServiceState __setServiceState(String service, J2EEServiceState state) {
        ServiceItem serviceItem = this.getServiceItem(service);
        if (serviceItem == null) {
            this.__getlogger().error((Object)("Service " + service + " not known"), new Object[0]);
            return null;
        }
        serviceItem.setState(state);
        if (serviceItem.getServiceLevel() != ServiceItem.ServiceLevel.MANDATORY) {
            this.checkServerState(service);
        }
        return state;
    }

    public String getServiceState(String string) {
        String string2;
        if (!this.__MgetServiceState$java_lang_String) {
            return this.__getServiceState(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getServiceState$java_lang_String", new Object[]{string});
            string2 = this.__getServiceState(string);
            this.__IM.onExit((Object)this, "getServiceState$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServiceState$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getServiceState(String service) {
        ServiceItem serviceItem = this.getServiceItem(service);
        if (serviceItem != null) {
            return serviceItem.getState().toString();
        }
        this.__getlogger().error((Object)("getServiceState called but service " + service + " not known"), new Object[0]);
        return null;
    }

    public String getServiceDescription(String string) {
        String string2;
        if (!this.__MgetServiceDescription$java_lang_String) {
            return this.__getServiceDescription(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getServiceDescription$java_lang_String", new Object[]{string});
            string2 = this.__getServiceDescription(string);
            this.__IM.onExit((Object)this, "getServiceDescription$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServiceDescription$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getServiceDescription(String service) {
        ServiceItem serviceItem = this.getServiceItem(service);
        if (serviceItem != null) {
            return serviceItem.getDescription();
        }
        this.__getlogger().error((Object)("getServiceDescription called but service " + service + " not known"), new Object[0]);
        return null;
    }

    private List<String> getNonRunningServices() {
        List<String> list;
        if (!this.__MgetNonRunningServices) {
            return this.__getNonRunningServices();
        }
        try {
            this.__IM.onEntry((Object)this, "getNonRunningServices", new Object[0]);
            list = this.__getNonRunningServices();
            this.__IM.onExit((Object)this, "getNonRunningServices", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getNonRunningServices", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getNonRunningServices() {
        ArrayList<String> services = new ArrayList<String>();
        for (ServiceItem serviceItem : this.__getserviceItems()) {
            J2EEServiceState state = serviceItem.getState();
            if (state.equals((Object)J2EEServiceState.RUNNING)) continue;
            services.add(serviceItem.getName());
        }
        return services;
    }

    private boolean allOptionalServicesStopped() {
        boolean bl;
        if (!this.__MallOptionalServicesStopped) {
            return this.__allOptionalServicesStopped();
        }
        try {
            this.__IM.onEntry((Object)this, "allOptionalServicesStopped", new Object[0]);
            bl = this.__allOptionalServicesStopped();
            this.__IM.onExit((Object)this, "allOptionalServicesStopped", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "allOptionalServicesStopped", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __allOptionalServicesStopped() {
        for (ServiceItem serviceItem : this.__getserviceItems()) {
            J2EEServiceState state = serviceItem.getState();
            if (serviceItem.getServiceLevel() == ServiceItem.ServiceLevel.MANDATORY || state.equals((Object)J2EEServiceState.STOPPED)) continue;
            return false;
        }
        return true;
    }

    private void checkServerState(String string) {
        if (!this.__McheckServerState$java_lang_String) {
            this.__checkServerState(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "checkServerState$java_lang_String", new Object[]{string});
            this.__checkServerState(string);
            this.__IM.onExit((Object)this, "checkServerState$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "checkServerState$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __checkServerState(String service) {
        if (this.__getj2eeServer() != null) {
            if (this.__getj2eeServer().isStarting() && this.getNonRunningServices().isEmpty() && !this.startMonitoring()) {
                this.__getj2eeServer().setRunning();
            }
            if (this.__getj2eeServer().isRunning() && "depmonitor".equals(service) && this.depMonitorRunning()) {
                this.startMonitoring();
            }
            if ((this.__getj2eeServer().isRunning() || this.__getj2eeServer().isStopping()) && this.allOptionalServicesStopped()) {
                this.__getj2eeServer().setStopped();
            }
        }
    }

    private boolean startMonitoring() {
        boolean bl;
        if (!this.__MstartMonitoring) {
            return this.__startMonitoring();
        }
        try {
            this.__IM.onEntry((Object)this, "startMonitoring", new Object[0]);
            bl = this.__startMonitoring();
            this.__IM.onExit((Object)this, "startMonitoring", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startMonitoring", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __startMonitoring() {
        ServiceReference reference = this.depMonitorReference();
        if (reference != null) {
            MonitoringService monitoringService = (MonitoringService)this.__getbundleContext().getService(reference);
            monitoringService.startMonitoring();
            return true;
        }
        return false;
    }

    private boolean depMonitorRunning() {
        boolean bl;
        if (!this.__MdepMonitorRunning) {
            return this.__depMonitorRunning();
        }
        try {
            this.__IM.onEntry((Object)this, "depMonitorRunning", new Object[0]);
            bl = this.__depMonitorRunning();
            this.__IM.onExit((Object)this, "depMonitorRunning", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "depMonitorRunning", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __depMonitorRunning() {
        return this.depMonitorReference() != null;
    }

    private ServiceReference depMonitorReference() {
        ServiceReference serviceReference;
        if (!this.__MdepMonitorReference) {
            return this.__depMonitorReference();
        }
        try {
            this.__IM.onEntry((Object)this, "depMonitorReference", new Object[0]);
            serviceReference = this.__depMonitorReference();
            this.__IM.onExit((Object)this, "depMonitorReference", (Object)serviceReference);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "depMonitorReference", throwable);
            throw throwable;
        }
        return serviceReference;
    }

    private ServiceReference __depMonitorReference() {
        return this.__getbundleContext().getServiceReference(MonitoringService.class.getName());
    }

    public void startService(String string) throws Exception {
        if (!this.__MstartService$java_lang_String) {
            this.__startService(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startService$java_lang_String", new Object[]{string});
            this.__startService(string);
            this.__IM.onExit((Object)this, "startService$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startService$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __startService(String service) throws Exception {
        this.startService(service, ServiceItem.ServiceLevel.OPTIONAL);
    }

    private void startService(String string, ServiceItem.ServiceLevel serviceLevel) throws Exception {
        if (!this.__MstartService$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel) {
            this.__startService(string, serviceLevel);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startService$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel", new Object[]{string, serviceLevel});
            this.__startService(string, serviceLevel);
            this.__IM.onExit((Object)this, "startService$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startService$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel", throwable);
            throw throwable;
        }
    }

    private void __startService(String service, ServiceItem.ServiceLevel level) throws Exception {
        if (this.isServiceStopped(service)) {
            if (this.__getconfigurationManager().matchService(service)) {
                ServiceItem serviceItem = this.getServiceItem(service);
                if (serviceItem == null) {
                    serviceItem = this.createServiceItem(service, level);
                    this.addServiceItem(serviceItem);
                }
                serviceItem.setState(J2EEServiceState.STARTING);
                this.__getconfigurationManager().updateServiceConfiguration(service);
            }
            if ("ejb3".equals(service) || "jaxws".equals(service) || "ejb3-client".equals(service)) {
                this.deployEasyBeans();
            }
            if (!"ejb3-client".equals(service)) {
                this.__getdeploymentPlanDeployer().deploy(service);
            }
        } else {
            this.__getlogger().debug((Object)"Service ''{0}'' is already starting or running", new Object[]{service});
        }
    }

    public void startRequiredServices(IDeployable<?> iDeployable) {
        if (!this.__MstartRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this.__startRequiredServices(iDeployable);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            this.__startRequiredServices(iDeployable);
            this.__IM.onExit((Object)this, "startRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
    }

    private void __startRequiredServices(IDeployable<?> deployable) {
        IArchiveMetadata metadata;
        if (this.__getserverProperties().isDevelopment()) {
            String service;
            if (EARDeployable.class.isInstance(deployable)) {
                for (IDeployable internalDeployable : ((EARDeployable)EARDeployable.class.cast(deployable)).getAllDeployables()) {
                    this.startRequiredServices(internalDeployable);
                }
            }
            if ((service = DeployableEnumeration.getService(deployable)) != null) {
                try {
                    if (this.isServiceStopped(service)) {
                        this.startService(service, ServiceItem.ServiceLevel.REQUIRED);
                        this.waitForServiceRegistration(service);
                    }
                }
                catch (Exception e) {
                    this.__getlogger().error((Object)"Cannot start required service ''{0}''", new Object[]{service, e});
                }
            }
        }
        if ((metadata = deployable.getArchive().getMetadata()) != null) {
            String services = metadata.get(REQUIRE_JONAS_SERVICES);
            for (String service : this.convertToList(services)) {
                try {
                    this.startService(service, ServiceItem.ServiceLevel.REQUIRED);
                }
                catch (Exception e) {
                    this.__getlogger().error((Object)"Cannot start required service ''{0}''", new Object[]{service, e});
                }
            }
        }
    }

    public void stopService(String string) throws Exception {
        if (!this.__MstopService$java_lang_String) {
            this.__stopService(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopService$java_lang_String", new Object[]{string});
            this.__stopService(string);
            this.__IM.onExit((Object)this, "stopService$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopService$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __stopService(String service) throws Exception {
        try {
            this.__getconfigurationManager().deleteServiceConfiguration(service);
        }
        catch (Exception e) {
            this.__getlogger().error((Object)"Cannot delete configuration for the ''{0 }}' service", new Object[]{service});
        }
    }

    public void startServices() {
        if (!this.__MstartServices) {
            this.__startServices();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startServices", new Object[0]);
            this.__startServices();
            this.__IM.onExit((Object)this, "startServices", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startServices", throwable);
            throw throwable;
        }
    }

    private void __startServices() {
        this.startServices(true);
    }

    private void startServices(boolean bl) {
        if (!this.__MstartServices$boolean) {
            this.__startServices(bl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startServices$boolean", new Object[]{new Boolean(bl)});
            this.__startServices(bl);
            this.__IM.onExit((Object)this, "startServices$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startServices$boolean", throwable);
            throw throwable;
        }
    }

    private void __startServices(boolean updateServiceStates) {
        if (updateServiceStates) {
            this.updateServiceItems();
        }
        new Thread(){

            public void run() {
                if (ServiceManagerImpl.this.__getserverProperties().isDevelopment()) {
                    try {
                        ServiceManagerImpl.this.startService("wc");
                    }
                    catch (Exception e) {
                        ServiceManagerImpl.this.__getlogger().error((Object)"Cannot start the work cleaner service", new Object[]{e});
                    }
                }
                for (String service : ServiceManagerImpl.this.getOptionalServices()) {
                    try {
                        ServiceManagerImpl.this.startService(service);
                    }
                    catch (Exception e) {
                        ServiceManagerImpl.this.__getlogger().error((Object)"Cannot start the ''{0}'' service", new Object[]{service, e});
                    }
                }
                try {
                    ServiceManagerImpl.access$202(ServiceManagerImpl.this, true);
                    Thread.sleep(20000L);
                    ServiceManagerImpl.this.checkServiceStates();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void stopServices() {
        if (!this.__MstopServices) {
            this.__stopServices();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopServices", new Object[0]);
            this.__stopServices();
            this.__IM.onExit((Object)this, "stopServices", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopServices", throwable);
            throw throwable;
        }
    }

    private void __stopServices() {
        List<String> services = this.getOptionalServices();
        if (services.contains("ear")) {
            services.remove("ear");
            services.add(0, "ear");
        }
        if (services.contains("depmonitor")) {
            services.remove("depmonitor");
            services.add(0, "depmonitor");
        }
        for (String service : services) {
            try {
                this.stopService(service);
            }
            catch (Exception e) {
                this.__getlogger().error((Object)"Cannot stop the ''{}'' service", new Object[]{e});
            }
        }
    }

    private ServiceItem createServiceItem(String string, ServiceItem.ServiceLevel serviceLevel) {
        ServiceItem serviceItem;
        if (!this.__McreateServiceItem$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel) {
            return this.__createServiceItem(string, serviceLevel);
        }
        try {
            this.__IM.onEntry((Object)this, "createServiceItem$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel", new Object[]{string, serviceLevel});
            serviceItem = this.__createServiceItem(string, serviceLevel);
            this.__IM.onExit((Object)this, "createServiceItem$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel", (Object)serviceItem);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createServiceItem$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel", throwable);
            throw throwable;
        }
        return serviceItem;
    }

    private ServiceItem __createServiceItem(String service, ServiceItem.ServiceLevel serviceLevel) {
        return this.createServiceItem(service, serviceLevel, J2EEServiceState.STOPPED);
    }

    private ServiceItem createServiceItem(String string, ServiceItem.ServiceLevel serviceLevel, J2EEServiceState j2EEServiceState) {
        ServiceItem serviceItem;
        if (!this.__McreateServiceItem$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel$org_ow2_jonas_lib_management_javaee_J2EEServiceState) {
            return this.__createServiceItem(string, serviceLevel, j2EEServiceState);
        }
        try {
            this.__IM.onEntry((Object)this, "createServiceItem$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel$org_ow2_jonas_lib_management_javaee_J2EEServiceState", new Object[]{string, serviceLevel, j2EEServiceState});
            serviceItem = this.__createServiceItem(string, serviceLevel, j2EEServiceState);
            this.__IM.onExit((Object)this, "createServiceItem$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel$org_ow2_jonas_lib_management_javaee_J2EEServiceState", (Object)serviceItem);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createServiceItem$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel$org_ow2_jonas_lib_management_javaee_J2EEServiceState", throwable);
            throw throwable;
        }
        return serviceItem;
    }

    private ServiceItem __createServiceItem(String name, ServiceItem.ServiceLevel serviceLevel, J2EEServiceState state) {
        ServiceItem serviceItem = new ServiceItem();
        serviceItem.setName(name);
        serviceItem.setDescription(name + " description ...");
        serviceItem.setState(state);
        serviceItem.setServiceLevel(serviceLevel);
        return serviceItem;
    }

    public void bindJ2EEServer(J2EEServerService j2EEServerService) {
        if (!this.__MbindJ2EEServer$org_ow2_jonas_management_J2EEServerService) {
            this.__bindJ2EEServer(j2EEServerService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindJ2EEServer$org_ow2_jonas_management_J2EEServerService", new Object[]{j2EEServerService});
            this.__bindJ2EEServer(j2EEServerService);
            this.__IM.onExit((Object)this, "bindJ2EEServer$org_ow2_jonas_management_J2EEServerService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindJ2EEServer$org_ow2_jonas_management_J2EEServerService", throwable);
            throw throwable;
        }
    }

    private void __bindJ2EEServer(J2EEServerService j2eeServer) {
        this.__setj2eeServer(j2eeServer);
    }

    public void unbindJ2EEServer(J2EEServerService j2EEServerService) {
        if (!this.__MunbindJ2EEServer$org_ow2_jonas_management_J2EEServerService) {
            this.__unbindJ2EEServer(j2EEServerService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindJ2EEServer$org_ow2_jonas_management_J2EEServerService", new Object[]{j2EEServerService});
            this.__unbindJ2EEServer(j2EEServerService);
            this.__IM.onExit((Object)this, "unbindJ2EEServer$org_ow2_jonas_management_J2EEServerService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindJ2EEServer$org_ow2_jonas_management_J2EEServerService", throwable);
            throw throwable;
        }
    }

    private void __unbindJ2EEServer(J2EEServerService j2eeServer) {
        this.__setj2eeServer(null);
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        if (!this.__MsetConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager) {
            this.__setConfigurationManager(configurationManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager", new Object[]{configurationManager});
            this.__setConfigurationManager(configurationManager);
            this.__IM.onExit((Object)this, "setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager", throwable);
            throw throwable;
        }
    }

    private void __setConfigurationManager(ConfigurationManager configurationManager) {
        this.__setconfigurationManager(configurationManager);
    }

    public void setDeployerManager(IDeployerManager iDeployerManager) {
        if (!this.__MsetDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager) {
            this.__setDeployerManager(iDeployerManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", new Object[]{iDeployerManager});
            this.__setDeployerManager(iDeployerManager);
            this.__IM.onExit((Object)this, "setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", throwable);
            throw throwable;
        }
    }

    private void __setDeployerManager(IDeployerManager deployerManager) {
        this.__setdeployerManager(deployerManager);
    }

    public void setDeploymentPlanDeployer(DeploymentPlanDeployer deploymentPlanDeployer) {
        if (!this.__MsetDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer) {
            this.__setDeploymentPlanDeployer(deploymentPlanDeployer);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer", new Object[]{deploymentPlanDeployer});
            this.__setDeploymentPlanDeployer(deploymentPlanDeployer);
            this.__IM.onExit((Object)this, "setDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer", throwable);
            throw throwable;
        }
    }

    private void __setDeploymentPlanDeployer(DeploymentPlanDeployer deploymentPlanDeployer) {
        this.__setdeploymentPlanDeployer(deploymentPlanDeployer);
    }

    public void setServerProperties(ServerProperties serverProperties) {
        if (!this.__MsetServerProperties$org_ow2_jonas_properties_ServerProperties) {
            this.__setServerProperties(serverProperties);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", new Object[]{serverProperties});
            this.__setServerProperties(serverProperties);
            this.__IM.onExit((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", throwable);
            throw throwable;
        }
    }

    private void __setServerProperties(ServerProperties serverProperties) {
        this.__setserverProperties(serverProperties);
    }

    public void disableServiceStatesCheck() {
        if (!this.__MdisableServiceStatesCheck) {
            this.__disableServiceStatesCheck();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "disableServiceStatesCheck", new Object[0]);
            this.__disableServiceStatesCheck();
            this.__IM.onExit((Object)this, "disableServiceStatesCheck", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "disableServiceStatesCheck", throwable);
            throw throwable;
        }
    }

    private void __disableServiceStatesCheck() {
        this.__setcheckServiceStates(false);
    }

    private void updateServiceItems() {
        if (!this.__MupdateServiceItems) {
            this.__updateServiceItems();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updateServiceItems", new Object[0]);
            this.__updateServiceItems();
            this.__IM.onExit((Object)this, "updateServiceItems", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateServiceItems", throwable);
            throw throwable;
        }
    }

    private void __updateServiceItems() {
        this.updateServiceItems(false);
    }

    private void updateServiceItems(boolean bl) {
        if (!this.__MupdateServiceItems$boolean) {
            this.__updateServiceItems(bl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updateServiceItems$boolean", new Object[]{new Boolean(bl)});
            this.__updateServiceItems(bl);
            this.__IM.onExit((Object)this, "updateServiceItems$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateServiceItems$boolean", throwable);
            throw throwable;
        }
    }

    private void __updateServiceItems(boolean startServiceListener) {
        this.deleteAllServiceItems();
        for (String service : this.__getconfigurationManager().getMandatoryServices()) {
            this.addServiceItem(this.createServiceItem(service, ServiceItem.ServiceLevel.MANDATORY));
        }
        for (String service : this.__getconfigurationManager().getOptionalServices()) {
            this.addServiceItem(this.createServiceItem(service, ServiceItem.ServiceLevel.OPTIONAL));
        }
        if (startServiceListener) {
            ServiceTracker listener = new ServiceTracker(this);
            this.__getbundleContext().addServiceListener((ServiceListener)listener);
        }
        try {
            List<String> runningServices = ServiceUtil.getRunningServices(this.__getbundleContext());
            for (String service : runningServices) {
                this.setServiceState(service, J2EEServiceState.RUNNING);
            }
        }
        catch (InvalidSyntaxException e) {
            this.__getlogger().error((Object)"Unable to get running services", new Object[]{e});
        }
    }

    private List<String> convertToList(String string) {
        List<String> list;
        if (!this.__MconvertToList$java_lang_String) {
            return this.__convertToList(string);
        }
        try {
            this.__IM.onEntry((Object)this, "convertToList$java_lang_String", new Object[]{string});
            list = this.__convertToList(string);
            this.__IM.onExit((Object)this, "convertToList$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "convertToList$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __convertToList(String param) {
        ArrayList<String> result = new ArrayList<String>();
        if (param != null && !param.equals("")) {
            for (String element : param.split(",")) {
                result.add(element);
            }
        }
        return result;
    }

    private void checkServiceStates() {
        if (!this.__McheckServiceStates) {
            this.__checkServiceStates();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "checkServiceStates", new Object[0]);
            this.__checkServiceStates();
            this.__IM.onExit((Object)this, "checkServiceStates", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "checkServiceStates", throwable);
            throw throwable;
        }
    }

    private void __checkServiceStates() {
        if (this.__getcheckServiceStates() && !this.getNonRunningServices().isEmpty()) {
            this.__getlogger().error((Object)"JOnAS server cannot reach the RUNNING state", new Object[0]);
            for (String service : this.getNonRunningServices()) {
                this.__getlogger().error((Object)"Service ''{0}'' is not running", new Object[]{service});
            }
            this.__getlogger().error((Object)"Please check the JOnAS server configuration.", new Object[0]);
        }
    }

    private void deployEasyBeans() throws Exception {
        if (!this.__MdeployEasyBeans) {
            this.__deployEasyBeans();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deployEasyBeans", new Object[0]);
            this.__deployEasyBeans();
            this.__IM.onExit((Object)this, "deployEasyBeans", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deployEasyBeans", throwable);
            throw throwable;
        }
    }

    private void __deployEasyBeans() throws Exception {
        Bundle[] bundles;
        String jpaProvider = (String)this.__getconfigurationManager().getServiceProperties("ejb3").get(JPA_PROVIDER);
        for (Bundle bundle : bundles = this.__getbundleContext().getBundles()) {
            String symbolicName = bundle.getSymbolicName();
            if (!symbolicName.startsWith(EASYBANS_PREFIX_SYMBOLIC_NAME) || symbolicName.endsWith(jpaProvider)) continue;
            bundle.uninstall();
        }
        this.__getdeploymentPlanDeployer().deploy("easybeans-".concat(jpaProvider));
    }

    private void waitForServiceRegistration(String string) {
        if (!this.__MwaitForServiceRegistration$java_lang_String) {
            this.__waitForServiceRegistration(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "waitForServiceRegistration$java_lang_String", new Object[]{string});
            this.__waitForServiceRegistration(string);
            this.__IM.onExit((Object)this, "waitForServiceRegistration$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "waitForServiceRegistration$java_lang_String", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __waitForServiceRegistration(String service) {
        long endTime = System.currentTimeMillis() + 10000L;
        ServiceManagerImpl serviceManagerImpl = this;
        synchronized (serviceManagerImpl) {
            while (!this.isServiceStarted(service)) {
                long timeout = endTime - System.currentTimeMillis();
                if (timeout > 0L) {
                    try {
                        this.wait(timeout);
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                this.__getlogger().error((Object)"Timout expired waiting for ''{0}'' service registration", new Object[]{service});
                return;
            }
        }
    }

    protected boolean isServiceStarted(String string) {
        boolean bl;
        if (!this.__MisServiceStarted$java_lang_String) {
            return this.__isServiceStarted(string);
        }
        try {
            this.__IM.onEntry((Object)this, "isServiceStarted$java_lang_String", new Object[]{string});
            bl = this.__isServiceStarted(string);
            this.__IM.onExit((Object)this, "isServiceStarted$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isServiceStarted$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isServiceStarted(String service) {
        return this.getServiceItem(service) != null && this.getServiceItem(service).getState() == J2EEServiceState.RUNNING;
    }

    protected boolean isServiceStopped(String string) {
        boolean bl;
        if (!this.__MisServiceStopped$java_lang_String) {
            return this.__isServiceStopped(string);
        }
        try {
            this.__IM.onEntry((Object)this, "isServiceStopped$java_lang_String", new Object[]{string});
            bl = this.__isServiceStopped(string);
            this.__IM.onExit((Object)this, "isServiceStopped$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isServiceStopped$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isServiceStopped(String service) {
        return this.getServiceItem(service) == null || this.getServiceItem(service).getState() == J2EEServiceState.STOPPED;
    }

    private ServiceItem getServiceItem(String string) {
        ServiceItem serviceItem;
        if (!this.__MgetServiceItem$java_lang_String) {
            return this.__getServiceItem(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getServiceItem$java_lang_String", new Object[]{string});
            serviceItem = this.__getServiceItem(string);
            this.__IM.onExit((Object)this, "getServiceItem$java_lang_String", (Object)serviceItem);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServiceItem$java_lang_String", throwable);
            throw throwable;
        }
        return serviceItem;
    }

    private ServiceItem __getServiceItem(String service) {
        for (ServiceItem serviceItem : this.__getserviceItems()) {
            if (!serviceItem.getName().equals(service)) continue;
            return serviceItem;
        }
        return null;
    }

    static /* synthetic */ boolean access$202(ServiceManagerImpl x0, boolean x1) {
        boolean bl = x1;
        x0.__setcheckServiceStates(bl);
        return bl;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("deploymentPlanDeployer")) {
                this.__FdeploymentPlanDeployer = true;
            }
            if (set.contains("serviceItems")) {
                this.__FserviceItems = true;
            }
            if (set.contains("bundleContext")) {
                this.__FbundleContext = true;
            }
            if (set.contains("deployerManagerCallback")) {
                this.__FdeployerManagerCallback = true;
            }
            if (set.contains("serverProperties")) {
                this.__FserverProperties = true;
            }
            if (set.contains("deployerManager")) {
                this.__FdeployerManager = true;
            }
            if (set.contains("j2eeServer")) {
                this.__Fj2eeServer = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("checkServiceStates")) {
                this.__FcheckServiceStates = true;
            }
            if (set.contains("configurationManager")) {
                this.__FconfigurationManager = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("addServiceItem$org_ow2_jonas_lib_service_manager_ServiceItem")) {
                this.__MaddServiceItem$org_ow2_jonas_lib_service_manager_ServiceItem = true;
            }
            if (set.contains("deleteAllServiceItems")) {
                this.__MdeleteAllServiceItems = true;
            }
            if (set.contains("getAllServices")) {
                this.__MgetAllServices = true;
            }
            if (set.contains("getOptionalServices")) {
                this.__MgetOptionalServices = true;
            }
            if (set.contains("setServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState")) {
                this.__MsetServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState = true;
            }
            if (set.contains("getServiceState$java_lang_String")) {
                this.__MgetServiceState$java_lang_String = true;
            }
            if (set.contains("getServiceDescription$java_lang_String")) {
                this.__MgetServiceDescription$java_lang_String = true;
            }
            if (set.contains("getNonRunningServices")) {
                this.__MgetNonRunningServices = true;
            }
            if (set.contains("allOptionalServicesStopped")) {
                this.__MallOptionalServicesStopped = true;
            }
            if (set.contains("checkServerState$java_lang_String")) {
                this.__McheckServerState$java_lang_String = true;
            }
            if (set.contains("startMonitoring")) {
                this.__MstartMonitoring = true;
            }
            if (set.contains("depMonitorRunning")) {
                this.__MdepMonitorRunning = true;
            }
            if (set.contains("depMonitorReference")) {
                this.__MdepMonitorReference = true;
            }
            if (set.contains("startService$java_lang_String")) {
                this.__MstartService$java_lang_String = true;
            }
            if (set.contains("startService$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel")) {
                this.__MstartService$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel = true;
            }
            if (set.contains("startRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__MstartRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("stopService$java_lang_String")) {
                this.__MstopService$java_lang_String = true;
            }
            if (set.contains("startServices")) {
                this.__MstartServices = true;
            }
            if (set.contains("startServices$boolean")) {
                this.__MstartServices$boolean = true;
            }
            if (set.contains("stopServices")) {
                this.__MstopServices = true;
            }
            if (set.contains("createServiceItem$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel")) {
                this.__McreateServiceItem$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel = true;
            }
            if (set.contains("createServiceItem$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel$org_ow2_jonas_lib_management_javaee_J2EEServiceState")) {
                this.__McreateServiceItem$java_lang_String$org_ow2_jonas_lib_service_manager_ServiceItem$ServiceLevel$org_ow2_jonas_lib_management_javaee_J2EEServiceState = true;
            }
            if (set.contains("bindJ2EEServer$org_ow2_jonas_management_J2EEServerService")) {
                this.__MbindJ2EEServer$org_ow2_jonas_management_J2EEServerService = true;
            }
            if (set.contains("unbindJ2EEServer$org_ow2_jonas_management_J2EEServerService")) {
                this.__MunbindJ2EEServer$org_ow2_jonas_management_J2EEServerService = true;
            }
            if (set.contains("setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager")) {
                this.__MsetConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager = true;
            }
            if (set.contains("setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager")) {
                this.__MsetDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager = true;
            }
            if (set.contains("setDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer")) {
                this.__MsetDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer = true;
            }
            if (set.contains("setServerProperties$org_ow2_jonas_properties_ServerProperties")) {
                this.__MsetServerProperties$org_ow2_jonas_properties_ServerProperties = true;
            }
            if (set.contains("disableServiceStatesCheck")) {
                this.__MdisableServiceStatesCheck = true;
            }
            if (set.contains("updateServiceItems")) {
                this.__MupdateServiceItems = true;
            }
            if (set.contains("updateServiceItems$boolean")) {
                this.__MupdateServiceItems$boolean = true;
            }
            if (set.contains("convertToList$java_lang_String")) {
                this.__MconvertToList$java_lang_String = true;
            }
            if (set.contains("checkServiceStates")) {
                this.__McheckServiceStates = true;
            }
            if (set.contains("deployEasyBeans")) {
                this.__MdeployEasyBeans = true;
            }
            if (set.contains("waitForServiceRegistration$java_lang_String")) {
                this.__MwaitForServiceRegistration$java_lang_String = true;
            }
            if (set.contains("isServiceStarted$java_lang_String")) {
                this.__MisServiceStarted$java_lang_String = true;
            }
            if (set.contains("isServiceStopped$java_lang_String")) {
                this.__MisServiceStopped$java_lang_String = true;
            }
            if (set.contains("getServiceItem$java_lang_String")) {
                this.__MgetServiceItem$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

