/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.processor.PollEnricher;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="pollEnrich")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PollEnrichDefinition
extends OutputDefinition<PollEnrichDefinition> {
    @XmlAttribute(name="uri", required=true)
    private String resourceUri;
    @XmlAttribute(name="timeout")
    private Long timeout;
    @XmlAttribute(name="strategyRef")
    private String aggregationStrategyRef;
    @XmlTransient
    private AggregationStrategy aggregationStrategy;

    public PollEnrichDefinition() {
        this(null, null, 0L);
    }

    public PollEnrichDefinition(AggregationStrategy aggregationStrategy, String resourceUri, long timeout) {
        this.aggregationStrategy = aggregationStrategy;
        this.resourceUri = resourceUri;
        this.timeout = timeout;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public String getAggregationStrategyRef() {
        return this.aggregationStrategyRef;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public String toString() {
        return "PollEnrich[" + this.resourceUri + " " + this.aggregationStrategy + "]";
    }

    @Override
    public String getShortName() {
        return "pollEnrich";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Endpoint endpoint = routeContext.resolveEndpoint(this.resourceUri);
        PollEnricher enricher = this.timeout != null ? new PollEnricher(null, endpoint.createPollingConsumer(), this.timeout) : new PollEnricher(null, endpoint.createPollingConsumer(), 0L);
        if (this.aggregationStrategyRef != null) {
            this.aggregationStrategy = routeContext.lookup(this.aggregationStrategyRef, AggregationStrategy.class);
        }
        if (this.aggregationStrategy == null) {
            enricher.setDefaultAggregationStrategy();
        } else {
            enricher.setAggregationStrategy(this.aggregationStrategy);
        }
        return enricher;
    }
}

