/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cmi.internal;

import java.io.FileNotFoundException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.jonas.cmi.internal.BundleContent;
import org.ow2.jonas.cmi.internal.CmiServiceException;
import org.ow2.jonas.cmi.internal.CmiServiceHelper;
import org.ow2.jonas.lib.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmiServicePolicyStrategyManager {
    private static Logger LOGGER = Log.getLogger((String)"org.ow2.jonas.cmi");
    private ServerClusterViewManager serverClusterViewManager = null;
    private HashMap<String, BundleContent> deployedBundleId = new HashMap();

    public CmiServicePolicyStrategyManager() {
    }

    public CmiServicePolicyStrategyManager(ServerClusterViewManager serverClusterViewManager) {
        this.serverClusterViewManager = serverClusterViewManager;
    }

    public void addPolicyStrategyBundle(String location, Class<? extends IPolicy<?>>[] policies, Class<? extends IStrategy<?>>[] strategies) throws CmiServiceException {
        String bundleId = null;
        Class<?>[] filteredPolicies = this.removeAbstractAndInterfaces(policies);
        Class<?>[] filteredStrategies = this.removeAbstractAndInterfaces(strategies);
        BundleContent policiesAndStrategies = new BundleContent(location, filteredPolicies, filteredStrategies);
        try {
            bundleId = CmiServiceHelper.sendBundle(this.serverClusterViewManager, policiesAndStrategies);
            if (this.deployedBundleId.containsKey(bundleId)) {
                this.deployedBundleId.remove(bundleId);
            }
            this.deployedBundleId.put(bundleId, policiesAndStrategies);
        }
        catch (FileNotFoundException e) {
            LOGGER.log(BasicLevel.ERROR, (Object)("Unable to load archive located at '" + policiesAndStrategies.getLocation() + "' because " + e));
            throw new CmiServiceException(e.getMessage());
        }
    }

    private Class<?>[] removeAbstractAndInterfaces(Class<?>[] classes) {
        ArrayList ret = new ArrayList();
        for (Class<?> clz : classes) {
            if (Modifier.isAbstract(clz.getModifiers()) || Modifier.isInterface(clz.getModifiers())) continue;
            ret.add(clz);
        }
        return ret.toArray(new Class[ret.size()]);
    }

    public void removePolicyStrategyBundle(String location) throws CmiServiceException {
        try {
            String bundleId = null;
            bundleId = this.getBundleId(location);
            boolean isOwner = false;
            if (bundleId.contains(this.serverClusterViewManager.getUUID().toString())) {
                isOwner = true;
            }
            BundleContent bundleContent = this.deployedBundleId.get(bundleId);
            this.serverClusterViewManager.removeLoadBalancingArchive((Object)bundleId, bundleContent.getPolicyNames(), bundleContent.getStrategyNames(), isOwner);
        }
        catch (Exception e) {
            throw new CmiServiceException(e.getMessage());
        }
    }

    private String getBundleId(String location) throws CmiServiceException {
        for (Map.Entry<String, BundleContent> entry : this.deployedBundleId.entrySet()) {
            String key = entry.getKey();
            BundleContent bundleContent = entry.getValue();
            if (!bundleContent.getLocation().equals(location)) continue;
            return key;
        }
        throw new CmiServiceException(" Unable to find Id for bundle deployed at " + location);
    }
}

