/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileBinding;
import org.apache.camel.util.IOHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBinding
implements GenericFileBinding<File> {
    private File body;
    private byte[] content;

    @Override
    public Object getBody(GenericFile<File> file) {
        if (this.content != null) {
            return this.content;
        }
        if (this.body == null || !file.getAbsoluteFilePath().equals(this.body.getAbsolutePath())) {
            this.body = new File(file.getAbsoluteFilePath());
        }
        return this.body;
    }

    @Override
    public void setBody(GenericFile<File> file, Object body) {
    }

    @Override
    public void loadContent(Exchange exchange, GenericFile<File> file) throws IOException {
        try {
            this.content = exchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, file.getFile());
        }
        catch (NoTypeConversionAvailableException e) {
            throw IOHelper.createIOException("Cannot load file content: " + file.getAbsoluteFilePath(), e);
        }
    }
}

