/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RouteNode;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.TraceableUnitOfWork;
import org.apache.camel.util.UuidGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUnitOfWork
implements TraceableUnitOfWork,
Service {
    private static final transient Log LOG = LogFactory.getLog(DefaultUnitOfWork.class);
    private static final UuidGenerator DEFAULT_ID_GENERATOR = new UuidGenerator();
    private String id;
    private List<Synchronization> synchronizations;
    private List<RouteNode> routeNodes;
    private Map<ProcessorDefinition, AtomicInteger> routeIndex = new HashMap<ProcessorDefinition, AtomicInteger>();
    private Message originalInMessage;

    public DefaultUnitOfWork(Exchange exchange) {
        if (exchange.getIn().getClass().getSimpleName().equals("JmsMessage")) {
            this.originalInMessage = new DefaultMessage();
            this.originalInMessage.setBody(exchange.getIn().getBody());
        } else {
            this.originalInMessage = exchange.getIn().copy();
        }
    }

    @Override
    public void start() throws Exception {
        this.id = null;
    }

    @Override
    public void stop() throws Exception {
        if (this.synchronizations != null) {
            this.synchronizations.clear();
        }
        if (this.routeNodes != null) {
            this.routeNodes.clear();
        }
        this.routeIndex.clear();
        this.originalInMessage = null;
    }

    @Override
    public synchronized void addSynchronization(Synchronization synchronization) {
        if (this.synchronizations == null) {
            this.synchronizations = new ArrayList<Synchronization>();
        }
        this.synchronizations.add(synchronization);
    }

    @Override
    public synchronized void removeSynchronization(Synchronization synchronization) {
        if (this.synchronizations != null) {
            this.synchronizations.remove(synchronization);
        }
    }

    @Override
    public void handoverSynchronization(Exchange target) {
        if (this.synchronizations == null || this.synchronizations.isEmpty()) {
            return;
        }
        for (Synchronization synchronization : this.synchronizations) {
            target.addOnCompletion(synchronization);
        }
        this.synchronizations.clear();
    }

    @Override
    public void done(Exchange exchange) {
        if (this.synchronizations != null && !this.synchronizations.isEmpty()) {
            boolean failed = exchange.isFailed();
            for (Synchronization synchronization : this.synchronizations) {
                try {
                    if (failed) {
                        synchronization.onFailure(exchange);
                        continue;
                    }
                    synchronization.onComplete(exchange);
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception occured during onCompletion. This exception will be ignored: ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = DEFAULT_ID_GENERATOR.generateId();
        }
        return this.id;
    }

    @Override
    public void addTraced(RouteNode entry) {
        if (this.routeNodes == null) {
            this.routeNodes = new ArrayList<RouteNode>();
        }
        this.routeNodes.add(entry);
    }

    @Override
    public RouteNode getLastNode() {
        if (this.routeNodes == null || this.routeNodes.isEmpty()) {
            return null;
        }
        return this.routeNodes.get(this.routeNodes.size() - 1);
    }

    @Override
    public RouteNode getSecondLastNode() {
        if (this.routeNodes == null || this.routeNodes.isEmpty() || this.routeNodes.size() == 1) {
            return null;
        }
        return this.routeNodes.get(this.routeNodes.size() - 2);
    }

    @Override
    public List<RouteNode> getNodes() {
        return Collections.unmodifiableList(this.routeNodes);
    }

    @Override
    public Message getOriginalInMessage() {
        return this.originalInMessage;
    }

    @Override
    public int getAndIncrement(ProcessorDefinition node) {
        AtomicInteger count = this.routeIndex.get(node);
        if (count == null) {
            count = new AtomicInteger();
            this.routeIndex.put(node, count);
        }
        return count.getAndIncrement();
    }
}

