/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.LoggingLevel;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.processor.Logger;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.commons.logging.LogFactory;

public class LoggingExceptionHandler
implements ExceptionHandler {
    private final Logger logger;

    public LoggingExceptionHandler(Class ownerType) {
        this(new Logger(LogFactory.getLog((Class)ownerType), LoggingLevel.ERROR));
    }

    public LoggingExceptionHandler(Logger logger) {
        this.logger = logger;
    }

    public void handleException(Throwable exception) {
        if (this.isCausedByRollbackExchangeException(exception)) {
            this.logger.log(exception.getMessage());
        } else {
            this.logger.log(exception.getMessage(), exception);
        }
    }

    protected boolean isCausedByRollbackExchangeException(Throwable exception) {
        if (exception instanceof RollbackExchangeException) {
            return true;
        }
        if (exception.getCause() != null) {
            return this.isCausedByRollbackExchangeException(exception.getCause());
        }
        return false;
    }
}

