/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.OtherwiseDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.processor.ChoiceProcessor;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CollectionStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="choice")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ChoiceDefinition
extends ProcessorDefinition<ChoiceDefinition> {
    @XmlElementRef
    private List<WhenDefinition> whenClauses = new ArrayList<WhenDefinition>();
    @XmlElement(required=false)
    private OtherwiseDefinition otherwise;

    public String toString() {
        if (this.getOtherwise() != null) {
            return "Choice[" + this.getWhenClauses() + " " + this.getOtherwise() + "]";
        }
        return "Choice[" + this.getWhenClauses() + "]";
    }

    @Override
    public String getShortName() {
        return "choice";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ArrayList<FilterProcessor> filters = new ArrayList<FilterProcessor>();
        for (WhenDefinition whenClaus : this.whenClauses) {
            filters.add(whenClaus.createProcessor(routeContext));
        }
        Processor otherwiseProcessor = null;
        if (this.otherwise != null) {
            otherwiseProcessor = this.otherwise.createProcessor(routeContext);
        }
        return new ChoiceProcessor(filters, otherwiseProcessor);
    }

    public ChoiceDefinition when(Predicate predicate) {
        this.getWhenClauses().add(new WhenDefinition(predicate));
        return this;
    }

    public ExpressionClause<ChoiceDefinition> when() {
        WhenDefinition when = new WhenDefinition();
        this.getWhenClauses().add(when);
        ExpressionClause<ChoiceDefinition> clause = new ExpressionClause<ChoiceDefinition>(this);
        when.setExpression(clause);
        return clause;
    }

    public ChoiceDefinition otherwise() {
        OtherwiseDefinition answer = new OtherwiseDefinition();
        this.setOtherwise(answer);
        return this;
    }

    @Override
    public String getLabel() {
        CollectionStringBuffer buffer = new CollectionStringBuffer();
        List<WhenDefinition> list = this.getWhenClauses();
        for (WhenDefinition whenType : list) {
            buffer.append(whenType.getLabel());
        }
        return buffer.toString();
    }

    public List<WhenDefinition> getWhenClauses() {
        return this.whenClauses;
    }

    public void setWhenClauses(List<WhenDefinition> whenClauses) {
        this.whenClauses = whenClauses;
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        if (this.otherwise != null) {
            return this.otherwise.getOutputs();
        }
        if (this.whenClauses.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        WhenDefinition when = this.whenClauses.get(this.whenClauses.size() - 1);
        return when.getOutputs();
    }

    public OtherwiseDefinition getOtherwise() {
        return this.otherwise;
    }

    public void setOtherwise(OtherwiseDefinition otherwise) {
        this.otherwise = otherwise;
    }
}

