/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.processor.Traceable;

public class TransformProcessor
extends DelegateProcessor
implements Traceable {
    private final Expression expression;

    public TransformProcessor(Expression expression) {
        this.expression = expression;
    }

    public TransformProcessor(Expression expression, Processor childProcessor) {
        super(childProcessor);
        this.expression = expression;
    }

    public void process(Exchange exchange) throws Exception {
        Object newBody = this.expression.evaluate(exchange, Object.class);
        exchange.getOut().setBody(newBody);
        exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
        exchange.getOut().setAttachments(exchange.getIn().getAttachments());
        super.process(exchange);
    }

    public String toString() {
        return "Transform(" + this.expression + (this.processor != null ? "," + this.processor : "") + ")";
    }

    public String getTraceLabel() {
        return "Transform[" + this.expression + "]";
    }
}

