/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class URISupport {
    private static final String CHARSET = "UTF-8";

    private URISupport() {
    }

    public static Map parseQuery(String uri) throws URISyntaxException {
        try {
            LinkedHashMap<String, String> rc = new LinkedHashMap<String, String>();
            if (uri != null) {
                String[] parameters;
                for (String parameter : parameters = uri.split("&")) {
                    int p = parameter.indexOf("=");
                    if (p >= 0) {
                        String name = URLDecoder.decode(parameter.substring(0, p), CHARSET);
                        String value = URLDecoder.decode(parameter.substring(p + 1), CHARSET);
                        rc.put(name, value);
                        continue;
                    }
                    rc.put(parameter, null);
                }
            }
            return rc;
        }
        catch (UnsupportedEncodingException e) {
            URISyntaxException se = new URISyntaxException(e.toString(), "Invalid encoding");
            se.initCause(e);
            throw se;
        }
    }

    public static Map parseParameters(URI uri) throws URISyntaxException {
        String query = uri.getQuery();
        if (query == null) {
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            int idx = schemeSpecificPart.lastIndexOf(63);
            if (idx < 0) {
                return Collections.EMPTY_MAP;
            }
            query = schemeSpecificPart.substring(idx + 1);
        } else {
            query = URISupport.stripPrefix(query, "?");
        }
        return URISupport.parseQuery(query);
    }

    public static URI removeQuery(URI uri) throws URISyntaxException {
        return URISupport.createURIWithQuery(uri, null);
    }

    public static URI createURIWithQuery(URI uri, String query) throws URISyntaxException {
        return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), query, uri.getFragment());
    }

    public static CompositeData parseComposite(URI uri) throws URISyntaxException {
        CompositeData rc = new CompositeData();
        rc.scheme = uri.getScheme();
        String ssp = URISupport.stripPrefix(uri.getSchemeSpecificPart().trim(), "//").trim();
        URISupport.parseComposite(uri, rc, ssp);
        rc.fragment = uri.getFragment();
        return rc;
    }

    private static void parseComposite(URI uri, CompositeData rc, String ssp) throws URISyntaxException {
        String params;
        String componentString;
        int p;
        if (!URISupport.checkParenthesis(ssp)) {
            throw new URISyntaxException(uri.toString(), "Not a matching number of '(' and ')' parenthesis");
        }
        int intialParen = ssp.indexOf(40);
        if (intialParen == 0) {
            rc.host = ssp.substring(0, intialParen);
            p = rc.host.indexOf("/");
            if (p >= 0) {
                rc.path = rc.host.substring(p);
                rc.host = rc.host.substring(0, p);
            }
            p = ssp.lastIndexOf(41);
            componentString = ssp.substring(intialParen + 1, p);
            params = ssp.substring(p + 1).trim();
        } else {
            componentString = ssp;
            params = "";
        }
        String[] components = URISupport.splitComponents(componentString);
        rc.components = new URI[components.length];
        for (int i = 0; i < components.length; ++i) {
            rc.components[i] = new URI(components[i].trim());
        }
        p = params.indexOf(63);
        if (p >= 0) {
            if (p > 0) {
                rc.path = URISupport.stripPrefix(params.substring(0, p), "/");
            }
            rc.parameters = URISupport.parseQuery(params.substring(p + 1));
        } else {
            if (params.length() > 0) {
                rc.path = URISupport.stripPrefix(params, "/");
            }
            rc.parameters = Collections.EMPTY_MAP;
        }
    }

    private static String[] splitComponents(String str) {
        ArrayList<String> l = new ArrayList<String>();
        int last = 0;
        int depth = 0;
        char[] chars = str.toCharArray();
        block5: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '(': {
                    ++depth;
                    continue block5;
                }
                case ')': {
                    --depth;
                    continue block5;
                }
                case ',': {
                    if (depth != 0) continue block5;
                    String s = str.substring(last, i);
                    l.add(s);
                    last = i + 1;
                    continue block5;
                }
            }
        }
        String s = str.substring(last);
        if (s.length() != 0) {
            l.add(s);
        }
        String[] rc = new String[l.size()];
        l.toArray(rc);
        return rc;
    }

    public static String stripPrefix(String value, String prefix) {
        if (value.startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    public static URI stripScheme(URI uri) throws URISyntaxException {
        return new URI(URISupport.stripPrefix(uri.getSchemeSpecificPart().trim(), "//"));
    }

    public static String createQueryString(Map options) throws URISyntaxException {
        try {
            if (options.size() > 0) {
                StringBuffer rc = new StringBuffer();
                boolean first = true;
                for (Object o : options.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        rc.append("&");
                    }
                    String key = (String)o;
                    String value = (String)options.get(key);
                    rc.append(URLEncoder.encode(key, CHARSET));
                    if (value == null) continue;
                    rc.append("=");
                    rc.append(URLEncoder.encode(value, CHARSET));
                }
                return rc.toString();
            }
            return "";
        }
        catch (UnsupportedEncodingException e) {
            URISyntaxException se = new URISyntaxException(e.toString(), "Invalid encoding");
            se.initCause(e);
            throw se;
        }
    }

    public static URI createRemainingURI(URI originalURI, Map params) throws URISyntaxException {
        String s = URISupport.createQueryString(params);
        if (s.length() == 0) {
            s = null;
        }
        return URISupport.createURIWithQuery(originalURI, s);
    }

    public static URI changeScheme(URI bindAddr, String scheme) throws URISyntaxException {
        return new URI(scheme, bindAddr.getUserInfo(), bindAddr.getHost(), bindAddr.getPort(), bindAddr.getPath(), bindAddr.getQuery(), bindAddr.getFragment());
    }

    public static boolean checkParenthesis(String str) {
        boolean result = true;
        if (str != null) {
            int open = 0;
            int closed = 0;
            int i = 0;
            while ((i = str.indexOf(40, i)) >= 0) {
                ++i;
                ++open;
            }
            i = 0;
            while ((i = str.indexOf(41, i)) >= 0) {
                ++i;
                ++closed;
            }
            result = open == closed;
        }
        return result;
    }

    public static String normalizeUri(String uri) throws URISyntaxException {
        Map parameters;
        int idx;
        URI u = new URI(UnsafeUriCharactersEncoder.encode(uri));
        String path = u.getSchemeSpecificPart();
        String scheme = u.getScheme();
        if (scheme == null || path == null) {
            return uri;
        }
        if (path.startsWith("//")) {
            path = path.substring(2);
        }
        if ((idx = path.indexOf(63)) > 0) {
            path = path.substring(0, idx);
        }
        if ((parameters = URISupport.parseParameters(u)).isEmpty()) {
            return URISupport.buildUri(scheme, path, null);
        }
        ArrayList keys = new ArrayList(parameters.keySet());
        Collections.sort(keys);
        LinkedHashMap sorted = new LinkedHashMap(parameters.size());
        for (String key : keys) {
            sorted.put(key, parameters.get(key));
        }
        String query = URISupport.createQueryString(sorted);
        return URISupport.buildUri(scheme, path, query);
    }

    private static String buildUri(String scheme, String path, String query) {
        return scheme + "://" + path + (query != null ? "?" + query : "");
    }

    public static class CompositeData {
        public String host;
        String scheme;
        String path;
        URI[] components;
        Map parameters;
        String fragment;

        public URI[] getComponents() {
            return this.components;
        }

        public String getFragment() {
            return this.fragment;
        }

        public Map getParameters() {
            return this.parameters;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getPath() {
            return this.path;
        }

        public String getHost() {
            return this.host;
        }

        public URI toURI() throws URISyntaxException {
            StringBuffer sb = new StringBuffer();
            if (this.scheme != null) {
                sb.append(this.scheme);
                sb.append(':');
            }
            if (this.host != null && this.host.length() != 0) {
                sb.append(this.host);
            } else {
                sb.append('(');
                for (int i = 0; i < this.components.length; ++i) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append(this.components[i].toString());
                }
                sb.append(')');
            }
            if (this.path != null) {
                sb.append('/');
                sb.append(this.path);
            }
            if (!this.parameters.isEmpty()) {
                sb.append("?");
                sb.append(URISupport.createQueryString(this.parameters));
            }
            if (this.fragment != null) {
                sb.append("#");
                sb.append(this.fragment);
            }
            return new URI(sb.toString());
        }
    }
}

