/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain.cluster.jk;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.management.domain.cluster.BaseCluster;
import org.ow2.jonas.lib.management.domain.cluster.ClusterMember;
import org.ow2.jonas.lib.management.domain.cluster.jk.JkClusterFactory;
import org.ow2.jonas.lib.management.domain.cluster.jk.JkClusterMBean;
import org.ow2.jonas.lib.management.domain.cluster.jk.JkClusterMember;
import org.ow2.jonas.lib.management.domain.proxy.server.ServerProxy;
import org.ow2.jonas.lib.util.JonasObjectName;

public class JkCluster
extends BaseCluster
implements JkClusterMBean {
    private String type = "JkCluster";
    private JProp jprop = null;
    private String lbWorker = null;
    private ArrayList balancedWorkers = new ArrayList();

    public JkCluster(JkClusterFactory cf) throws JMException {
        super(cf);
        try {
            this.jprop = JProp.getInstance((String)"workers.properties");
        }
        catch (RuntimeException e) {
            logger.log(BasicLevel.DEBUG, (Object)("Cannot find workers.properties:" + e));
            throw e;
        }
        this.getLbWorker();
        if (this.lbWorker == null) {
            logger.log(BasicLevel.WARN, (Object)"No Load Balancer worker in workers.properties");
            return;
        }
        this.getBalancedWorkerList();
        this.setName(this.lbWorker);
        cf.getMBeanServer().registerMBean(this, this.objectName);
    }

    public ClusterMember createClusterMember(String svname, ServerProxy proxy) {
        return new JkClusterMember(svname, proxy);
    }

    public String getType() {
        return this.type;
    }

    public boolean addWorker(String workerName, int workerPort, ServerProxy proxy) {
        boolean added;
        String lbFactorString;
        Integer lbFactor;
        String type;
        boolean found = false;
        for (String aWorkerName : this.balancedWorkers) {
            if (!workerName.equals(aWorkerName)) continue;
            found = true;
            String portString = (String)this.getWorkerProp(workerName, "port");
            Integer portValue = new Integer(portString);
            if (portValue == null || portValue == workerPort) break;
            logger.log(BasicLevel.WARN, (Object)("Bad port number for: " + workerName));
            break;
        }
        if (!found) {
            logger.log(BasicLevel.WARN, (Object)("Cannot find this worker in workers.properties:" + workerName));
            return false;
        }
        JkClusterMember worker = new JkClusterMember(workerName, proxy);
        worker.setPort(workerPort);
        String host = (String)this.getWorkerProp(workerName, "host");
        if (host != null) {
            worker.setHost(host);
        }
        if ((type = (String)this.getWorkerProp(workerName, "type")) != null) {
            worker.setType(type);
        }
        if ((lbFactor = new Integer(lbFactorString = (String)this.getWorkerProp(workerName, "lbfactor"))) != null) {
            worker.setLbfactor(lbFactor);
        }
        if (added = this.addMember(worker)) {
            try {
                ObjectName on = JonasObjectName.clusterMember((String)this.domainName, (String)workerName, (String)this.getType(), (String)this.name);
                worker.setObjectName(on);
                MBeanServer mbeanServer = this.jmx.getJmxServer();
                if (mbeanServer.isRegistered(on)) {
                    mbeanServer.unregisterMBean(on);
                }
                mbeanServer.registerMBean(worker, on);
            }
            catch (JMException e) {
                logger.log(BasicLevel.WARN, (Object)("Cannot register Worker " + workerName + ": " + e));
            }
        }
        return added;
    }

    private void getLbWorker() {
        String valueList = this.jprop.getValue("worker.list");
        StringTokenizer st = new StringTokenizer(valueList, ",");
        while (st.hasMoreTokens()) {
            String aWorker = st.nextToken();
            String key = "worker." + aWorker + ".type";
            String type = this.jprop.getValue(key);
            if (!"lb".equals(type)) continue;
            this.lbWorker = aWorker;
            break;
        }
    }

    private void getBalancedWorkerList() {
        String key = "worker." + this.lbWorker + ".balanced_workers";
        String valueList = this.jprop.getValue(key);
        StringTokenizer st = new StringTokenizer(valueList, ",");
        while (st.hasMoreTokens()) {
            String aWorker = st.nextToken();
            key = "worker." + aWorker + ".type";
            String type = this.jprop.getValue(key);
            if ("ajp13".equals(type)) {
                this.balancedWorkers.add(aWorker);
                continue;
            }
            logger.log(BasicLevel.WARN, (Object)("Bad worker type: " + type));
        }
    }

    private Object getWorkerProp(String workerName, String directive) {
        String valueObj = null;
        String key = "worker." + workerName + "." + directive;
        if (this.jprop != null) {
            valueObj = this.jprop.getValue(key);
        }
        return valueObj;
    }

    public String[] getBalancedWorkers() {
        String[] result = new String[this.balancedWorkers.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)this.balancedWorkers.get(i);
        }
        return result;
    }

    public boolean isStickySession() {
        String key = "worker." + this.lbWorker + ".sticky_session";
        return new Boolean(this.jprop.getValue(key));
    }
}

