/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsClientFactoryBean;
import org.apache.cxf.jaxws.JaxWsClientProxy;
import org.apache.cxf.jaxws.context.WebServiceContextResourceResolver;
import org.apache.cxf.jaxws.handler.AnnotationHandlerChainBuilder;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.resource.DefaultResourceManager;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsProxyFactoryBean
extends ClientProxyFactoryBean {
    List<Handler> handlers = new ArrayList<Handler>();
    boolean loadHandlers = true;

    public JaxWsProxyFactoryBean() {
        super(new JaxWsClientFactoryBean());
    }

    public JaxWsProxyFactoryBean(ClientFactoryBean fact) {
        super(fact);
    }

    public void setHandlers(List<Handler> h) {
        this.handlers.clear();
        this.handlers.addAll(h);
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public void setLoadHandlers(boolean b) {
        this.loadHandlers = b;
    }

    public boolean isLoadHandlers() {
        return this.loadHandlers;
    }

    @Override
    protected ClientProxy clientClientProxy(Client c) {
        JaxWsClientProxy cp = new JaxWsClientProxy(c, ((JaxWsEndpointImpl)c.getEndpoint()).getJaxwsBinding());
        cp.getRequestContext().putAll(this.getProperties());
        this.buildHandlerChain(cp);
        return cp;
    }

    @Override
    protected Class[] getImplementingClasses() {
        Class cls = this.getClientFactoryBean().getServiceClass();
        return new Class[]{cls, BindingProvider.class};
    }

    private void buildHandlerChain(JaxWsClientProxy cp) {
        AnnotationHandlerChainBuilder builder = new AnnotationHandlerChainBuilder();
        JaxWsServiceFactoryBean sf = (JaxWsServiceFactoryBean)this.getServiceFactory();
        ArrayList<Handler> chain = new ArrayList<Handler>(this.handlers);
        if (this.loadHandlers) {
            chain.addAll(builder.buildHandlerChainFromClass(sf.getServiceClass(), sf.getEndpointInfo().getName()));
        }
        if (!chain.isEmpty()) {
            ResourceManager resourceManager = this.getBus().getExtension(ResourceManager.class);
            List<ResourceResolver> resolvers = resourceManager.getResourceResolvers();
            resourceManager = new DefaultResourceManager(resolvers);
            resourceManager.addResourceResolver(new WebServiceContextResourceResolver());
            ResourceInjector injector = new ResourceInjector(resourceManager);
            for (Handler h : chain) {
                if (Proxy.isProxyClass(h.getClass()) && this.getServiceClass() != null) {
                    injector.inject(h, this.getServiceClass());
                    injector.construct(h, this.getServiceClass());
                    continue;
                }
                injector.inject(h);
                injector.construct(h);
            }
        }
        cp.getBinding().setHandlerChain(chain);
    }
}

