/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis2.jaxws.description.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.DescriptionKey;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.converter.JavaClassToDBCConverter;
import org.apache.axis2.jaxws.description.validator.EndpointDescriptionValidator;
import org.apache.axis2.jaxws.description.validator.ServiceDescriptionValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.jonas.ws.axis2.jaxws.description.impl.ServiceDescriptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionFactoryImpl {
    private static final Log log = LogFactory.getLog(DescriptionFactoryImpl.class);
    private static ClientConfigurationFactory clientConfigFactory = ClientConfigurationFactory.newInstance();
    private static Map<DescriptionKey, ServiceDescription> cache = new Hashtable<DescriptionKey, ServiceDescription>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceDescription createServiceDescription(URL wsdlURL, QName serviceQName, Class serviceClass) {
        ConfigurationContext configContext = DescriptionFactory.createClientConfigurationFactory().getClientConfigurationContext();
        DescriptionKey key = new DescriptionKey(serviceQName, wsdlURL, serviceClass, configContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cache Map = " + cache.toString()));
            if (key != null) {
                log.debug((Object)("Description Key = " + key.printKey()));
            }
        }
        ServiceDescription serviceDesc = null;
        ConfigurationContext configurationContext = configContext;
        synchronized (configurationContext) {
            serviceDesc = cache.get(key);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Check to see if ServiceDescription is found in cache");
            }
            if (serviceDesc != null && log.isDebugEnabled()) {
                log.debug((Object)"ServiceDescription found in the cache");
                log.debug((Object)serviceDesc.toString());
            }
            if (serviceDesc == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"ServiceDescription not found in the cache");
                    log.debug((Object)" creating new ServiceDescriptionImpl");
                }
                ServiceDescriptionImpl serviceDescImpl = new ServiceDescriptionImpl(wsdlURL, serviceQName, serviceClass);
                serviceDescImpl.setAxisConfigContext(configContext);
                serviceDesc = serviceDescImpl;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ServiceDescription created with WSDL URL: " + wsdlURL + "; QName: " + serviceQName + "; Class: " + serviceClass));
                    log.debug((Object)serviceDesc.toString());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Caching new ServiceDescription in the cache");
                }
                cache.put(key, serviceDesc);
            }
        }
        return serviceDesc;
    }

    public static void clearServiceDescriptionCache() {
        cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearServiceDescriptionCache(ConfigurationContext configContext) {
        if (configContext == null) {
            return;
        }
        ConfigurationContext configurationContext = configContext;
        synchronized (configurationContext) {
            Map<DescriptionKey, ServiceDescription> map = cache;
            synchronized (map) {
                Iterator<DescriptionKey> iter = cache.keySet().iterator();
                while (iter.hasNext()) {
                    DescriptionKey key = iter.next();
                    if (key.getConfigContext() != configContext) continue;
                    iter.remove();
                }
            }
        }
    }

    @Deprecated
    public static ServiceDescription createServiceDescriptionFromServiceImpl(Class serviceImplClass, AxisService axisService) {
        ServiceDescriptionImpl serviceDesc = new ServiceDescriptionImpl(serviceImplClass, axisService);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deprecated method used!  ServiceDescription created with Class: " + serviceImplClass + "; AxisService: " + axisService));
            log.debug((Object)((Object)serviceDesc).toString());
        }
        return serviceDesc;
    }

    public static ServiceDescription createServiceDescription(Class serviceImplClass) {
        ServiceDescription serviceDesc = null;
        if (serviceImplClass != null) {
            JavaClassToDBCConverter converter = new JavaClassToDBCConverter(serviceImplClass);
            HashMap dbcMap = converter.produceDBC();
            List<ServiceDescription> serviceDescList = DescriptionFactoryImpl.createServiceDescriptionFromDBCMap(dbcMap);
            if (serviceDescList != null && serviceDescList.size() > 0) {
                serviceDesc = serviceDescList.get(0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ServiceDescription created with class: " + serviceImplClass));
                    log.debug((Object)serviceDesc);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ServiceDesciption was not created for class: " + serviceImplClass));
                }
                throw ExceptionFactory.makeWebServiceException((String)("A ServiceDescription was not created for " + serviceImplClass));
            }
        }
        return serviceDesc;
    }

    public static List<ServiceDescription> createServiceDescriptionFromDBCMap(HashMap<String, DescriptionBuilderComposite> dbcMap) {
        ArrayList<ServiceDescription> serviceDescriptionList = new ArrayList<ServiceDescription>();
        for (DescriptionBuilderComposite serviceImplComposite : dbcMap.values()) {
            if (DescriptionFactoryImpl.isImpl(serviceImplComposite)) {
                ServiceDescriptionImpl serviceDescription = new ServiceDescriptionImpl(dbcMap, serviceImplComposite);
                ServiceDescriptionValidator validator = new ServiceDescriptionValidator((ServiceDescription)serviceDescription);
                if (validator.validate()) {
                    serviceDescriptionList.add(serviceDescription);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Service Description created from DescriptionComposite: " + serviceDescription));
                    continue;
                }
                String msg = "The ServiceDescription failed to validate due to the following errors: \n" + validator.toString();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Validation Phase 2 failure: " + msg));
                    log.debug((Object)("Failing composite: " + serviceImplComposite.toString()));
                    log.debug((Object)("Failing Service Description: " + ((Object)serviceDescription).toString()));
                }
                throw ExceptionFactory.makeWebServiceException((String)msg);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("DBC is not a service impl: " + serviceImplComposite.toString()));
        }
        return serviceDescriptionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, QName portQName, DescriptionFactory.UpdateType updateType) {
        EndpointDescription endpointDesc = null;
        ServiceDescription serviceDescription2 = serviceDescription;
        synchronized (serviceDescription2) {
            endpointDesc = ((ServiceDescriptionImpl)serviceDescription).updateEndpointDescription(sei, portQName, updateType);
        }
        EndpointDescriptionValidator endpointValidator = new EndpointDescriptionValidator(endpointDesc);
        boolean isEndpointValid = endpointValidator.validate();
        if (!isEndpointValid) {
            String msg = "The Endpoint description validation failed to validate due to the following errors: \n" + endpointValidator.toString();
            throw ExceptionFactory.makeWebServiceException((String)msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("EndpointDescription updated: " + endpointDesc));
        }
        return endpointDesc;
    }

    public static ClientConfigurationFactory getClientConfigurationFactory() {
        if (clientConfigFactory == null) {
            clientConfigFactory = ClientConfigurationFactory.newInstance();
        }
        return clientConfigFactory;
    }

    private static List<DescriptionBuilderComposite> buildRelevantCompositeList(List<DescriptionBuilderComposite> compositeList, String serviceImplName) {
        List<DescriptionBuilderComposite> relevantList = compositeList;
        return relevantList;
    }

    private static boolean isImpl(DescriptionBuilderComposite dbc) {
        return !dbc.isInterface() && (dbc.getWebServiceAnnot() != null || dbc.getWebServiceProviderAnnot() != null);
    }
}

