/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.common.Configuration;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.Pool;
import fr.dyade.aaa.common.Timer;
import fr.dyade.aaa.common.TimerTask;
import fr.dyade.aaa.util.AbstractTransaction;
import fr.dyade.aaa.util.NTransactionMBean;
import fr.dyade.aaa.util.Operation;
import fr.dyade.aaa.util.OperationKey;
import fr.dyade.aaa.util.Repository;
import fr.dyade.aaa.util.Transaction;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class NTransaction
extends AbstractTransaction
implements NTransactionMBean {
    private static Logger logmon = null;
    static int LogMemoryCapacity = 4096;
    static int MaxLogMemorySize = 0x200000;
    static int MaxLogFileSize = 0x1000000;
    static int LogThresholdOperation = 1000;
    private Timer timer = null;
    private GarbageTask task = null;
    long startTime = 0L;
    String repositoryImpl = "fr.dyade.aaa.util.FileRepository";
    File dir = null;
    LogFile logFile = null;
    Repository repository = null;
    static final boolean debug = false;

    public final int getLogMemoryCapacity() {
        return LogMemoryCapacity;
    }

    public final int getMaxLogMemorySize() {
        return MaxLogMemorySize / 1024;
    }

    public final void setMaxLogMemorySize(int size) {
        if (size > 0) {
            MaxLogMemorySize = size * 1024;
        }
    }

    public final int getLogMemorySize() {
        return this.logFile.logMemorySize;
    }

    public final int getMaxLogFileSize() {
        return MaxLogFileSize / 0x100000;
    }

    public final void setMaxLogFileSize(int size) {
        if (size > 0) {
            MaxLogFileSize = size * 0x100000;
        }
    }

    public final int getLogFileSize() {
        return this.logFile.getLogFileSize() / 1024;
    }

    public final int getLogThresholdOperation() {
        return LogThresholdOperation;
    }

    public final int getCommitCount() {
        return this.logFile.commitCount;
    }

    public final int getGarbageCount() {
        return this.logFile.garbageCount;
    }

    public final int getGarbageDelay() {
        return (int)(this.logFile.garbageTimeOut / 1000L);
    }

    public final void setGarbageDelay(int timeout) {
        this.logFile.garbageTimeOut = (long)timeout * 1000L;
    }

    public final boolean isGarbageRunning() {
        return false;
    }

    public void garbageAsync(boolean async) {
        if (async) {
            if (this.task == null) {
                this.task = new GarbageTask();
            }
        } else {
            if (this.task != null) {
                this.task.cancel();
            }
            this.task = null;
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = null;
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getGarbageTime() {
        return this.logFile.garbageTime;
    }

    public int getGarbageRatio() {
        return (int)(this.logFile.garbageTime * 100L / (System.currentTimeMillis() - this.startTime));
    }

    public String getRepositoryImpl() {
        return this.repositoryImpl;
    }

    public int getNbSavedObjects() {
        return this.repository.getNbSavedObjects();
    }

    public int getNbDeletedObjects() {
        return this.repository.getNbDeletedObjects();
    }

    public int getNbBadDeletedObjects() {
        return this.repository.getNbBadDeletedObjects();
    }

    public int getNbLoadedObjects() {
        return this.repository.getNbLoadedObjects();
    }

    public boolean isPersistent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(String path) throws IOException {
        this.phase = 0;
        LogMemoryCapacity = Configuration.getInteger("NTLogMemoryCapacity", LogMemoryCapacity);
        MaxLogFileSize = Configuration.getInteger("NTLogFileSize", MaxLogFileSize / 0x100000) * 0x100000;
        MaxLogMemorySize = Configuration.getInteger("NTLogMemorySize", MaxLogMemorySize / 1024) * 1024;
        LogThresholdOperation = Configuration.getInteger("NTLogThresholdOperation", LogThresholdOperation);
        Operation.pool = new Pool("NTransaction$Operation", LogThresholdOperation);
        logmon = Debug.getLogger(Transaction.class.getName());
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)("NTransaction, init():" + MaxLogFileSize / 0x100000 + '/' + MaxLogMemorySize / 1024));
        }
        this.dir = new File(path);
        if (!this.dir.exists()) {
            this.dir.mkdir();
        }
        if (!this.dir.isDirectory()) {
            throw new FileNotFoundException(path + " is not a directory.");
        }
        FilterOutputStream ldos = null;
        try {
            File tfc = new File(this.dir, "TFC");
            if (!tfc.exists()) {
                ldos = new DataOutputStream(new FileOutputStream(tfc));
                ((DataOutputStream)ldos).writeUTF(this.getClass().getName());
                ((DataOutputStream)ldos).flush();
            }
        }
        finally {
            if (ldos != null) {
                ldos.close();
            }
        }
        try {
            this.repositoryImpl = System.getProperty("NTRepositoryImpl", this.repositoryImpl);
            this.repository = (Repository)Class.forName(this.repositoryImpl).newInstance();
            this.repository.init(this.dir);
        }
        catch (ClassNotFoundException exc) {
            logmon.log(BasicLevel.FATAL, (Object)"NTransaction, cannot initializes the repository ", (Throwable)exc);
            throw new IOException(exc.getMessage());
        }
        catch (InstantiationException exc) {
            logmon.log(BasicLevel.FATAL, (Object)"NTransaction, cannot initializes the repository ", (Throwable)exc);
            throw new IOException(exc.getMessage());
        }
        catch (IllegalAccessException exc) {
            logmon.log(BasicLevel.FATAL, (Object)"NTransaction, cannot initializes the repository ", (Throwable)exc);
            throw new IOException(exc.getMessage());
        }
        this.logFile = new LogFile(this.dir, this.repository);
        this.perThreadContext = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new AbstractTransaction.Context();
            }
        };
        this.setGarbageDelay(Configuration.getInteger("NTGarbageDelay", this.getGarbageDelay()));
        this.garbageAsync(Configuration.getBoolean("NTAsyncGarbage"));
        this.startTime = System.currentTimeMillis();
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)("NTransaction, initialized " + this.startTime));
        }
        this.setPhase(1);
    }

    public String getPersistenceDir() {
        return this.dir.getPath();
    }

    protected final void setPhase(int newPhase) {
        this.phase = newPhase;
    }

    public synchronized String[] getList(String prefix) {
        int i;
        String[] list1 = null;
        try {
            list1 = this.repository.list(prefix);
        }
        catch (IOException exc) {
            // empty catch block
        }
        if (list1 == null) {
            list1 = new String[]{};
        }
        Object[] list2 = this.logFile.log.keySet().toArray();
        int nb = list1.length;
        for (int i2 = 0; i2 < list2.length; ++i2) {
            if (list2[i2] instanceof String && ((String)list2[i2]).startsWith(prefix)) {
                int j;
                for (j = 0; j < list1.length && !list2[i2].equals(list1[j]); ++j) {
                }
                if (j < list1.length) {
                    if (((Operation)this.logFile.log.get((Object)list2[i2])).type == 2) {
                        list1[j] = null;
                        --nb;
                    }
                    list2[i2] = null;
                    continue;
                }
                if (((Operation)this.logFile.log.get((Object)list2[i2])).type == 1 || ((Operation)this.logFile.log.get((Object)list2[i2])).type == 4) {
                    ++nb;
                    continue;
                }
                list2[i2] = null;
                continue;
            }
            list2[i2] = null;
        }
        String[] list = new String[nb];
        for (i = list1.length - 1; i >= 0; --i) {
            if (list1[i] == null) continue;
            list[--nb] = list1[i];
        }
        for (i = list2.length - 1; i >= 0; --i) {
            if (list2[i] == null) continue;
            list[--nb] = (String)list2[i];
        }
        return list;
    }

    protected final void saveInLog(byte[] buf, String dirName, String name, Hashtable log, boolean copy, boolean first) throws IOException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, saveInLog(" + dirName + '/' + name + ", " + copy + ", " + first + ")"));
        }
        Object key = OperationKey.newKey(dirName, name);
        Operation op = null;
        op = first ? Operation.alloc(4, dirName, name, buf) : Operation.alloc(1, dirName, name, buf);
        Operation old = log.put(key, op);
        if (copy) {
            op.value = old != null && old.type == 1 && old.value.length == buf.length ? old.value : new byte[buf.length];
            System.arraycopy(buf, 0, op.value, 0, buf.length);
        }
        if (old != null) {
            old.free();
        }
    }

    private final byte[] getFromLog(Hashtable log, Object key) throws IOException {
        Operation op = (Operation)log.get(key);
        if (op != null) {
            if (op.type == 1 || op.type == 4) {
                return op.value;
            }
            if (op.type == 2) {
                throw new FileNotFoundException();
            }
        }
        return null;
    }

    private final byte[] getFromLog(String dirName, String name) throws IOException {
        Object key = OperationKey.newKey(dirName, name);
        byte[] buf = this.getFromLog(((AbstractTransaction.Context)this.perThreadContext.get()).log, key);
        if (buf != null) {
            return buf;
        }
        buf = this.getFromLog(this.logFile.log, key);
        if (buf != null) {
            return buf;
        }
        return null;
    }

    public byte[] loadByteArray(String dirName, String name) throws IOException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, loadByteArray(" + dirName + '/' + name + ")"));
        }
        try {
            byte[] buf = this.getFromLog(dirName, name);
            if (buf != null) {
                return buf;
            }
            return this.repository.load(dirName, name);
        }
        catch (FileNotFoundException exc) {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, loadByteArray(" + dirName + '/' + name + ") not found"));
            }
            return null;
        }
    }

    public final void delete(String dirName, String name) {
        Operation op;
        Object key;
        Hashtable log;
        Operation old;
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, delete(" + dirName + ", " + name + ")"));
        }
        if ((old = (log = ((AbstractTransaction.Context)this.perThreadContext.get()).log).put(key = OperationKey.newKey(dirName, name), op = Operation.alloc(2, dirName, name))) != null) {
            if (old.type == 4) {
                op.type = 5;
            }
            old.free();
        }
    }

    public final synchronized void commit(boolean release) throws IOException {
        Hashtable log;
        if (this.phase != 2) {
            throw new IllegalStateException("Can not commit.");
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"NTransaction, commit");
        }
        if (!(log = ((AbstractTransaction.Context)this.perThreadContext.get()).log).isEmpty()) {
            this.logFile.commit(log);
            log.clear();
        }
        this.setPhase(3);
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"NTransaction, committed");
        }
        if (release) {
            this.setPhase(1);
            this.notify();
        }
    }

    public final synchronized void garbage() {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"NTransaction, garbages");
        }
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException exc) {}
        }
        this.setPhase(5);
        try {
            this.logFile.garbage();
        }
        catch (IOException exc) {
            logmon.log(BasicLevel.WARN, (Object)"NTransaction, can't garbage logfile", (Throwable)exc);
        }
        this.setPhase(1);
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)("NTransaction, garbaged: " + this.toString()));
        }
    }

    public synchronized void stop() {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"NTransaction, stops");
        }
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException exc) {}
        }
        this.setPhase(6);
        try {
            this.logFile.garbage();
        }
        catch (IOException exc) {
            logmon.log(BasicLevel.WARN, (Object)"NTransaction, can't garbage logfile", (Throwable)exc);
        }
        this.setPhase(1);
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)("NTransaction, stopped: " + this.toString()));
        }
    }

    public synchronized void close() {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"NTransaction, closes");
        }
        if (this.phase == 0) {
            return;
        }
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setPhase(6);
        this.logFile.stop();
        this.setPhase(0);
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)("NTransaction, closed: " + this.toString()));
        }
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append('(').append(super.toString());
        strbuf.append(",LogMemorySize=").append(this.getLogMemorySize());
        strbuf.append(",LogFileSize=").append(this.getLogFileSize());
        strbuf.append(",CommitCount=").append(this.getCommitCount());
        strbuf.append(",GarbageCount=").append(this.getGarbageCount());
        strbuf.append(",GarbageRatio=").append(this.getGarbageRatio());
        strbuf.append(",NbSavedObjects=").append(this.getNbSavedObjects());
        strbuf.append(",NbDeletedObjects=").append(this.getNbDeletedObjects());
        strbuf.append(",NbBadDeletedObjects=").append(this.getNbBadDeletedObjects());
        strbuf.append(",NbLoadedObjects=").append(this.getNbLoadedObjects());
        strbuf.append(')');
        return strbuf.toString();
    }

    public static void main(String[] args) throws Exception {
        if ("garbage".equals(args[0])) {
            NTransaction transaction = new NTransaction();
            transaction.init(args[1]);
            transaction.stop();
        } else if (!"list".equals(args[0])) {
            System.err.println("unknown command: " + args[0]);
        }
    }

    static final class LogFile
    extends ByteArrayOutputStream {
        Hashtable log = null;
        RandomAccessFile logFile = null;
        int current = -1;
        int commitCount = 0;
        int garbageCount = 0;
        long garbageTime = 0L;
        long lastGarbageTime = 0L;
        long garbageTimeOut = 0L;
        private static final String LockPathname = "lock";
        private File lockFile = null;
        private Repository repository = null;
        private static final byte[] emptyUTFString = new byte[]{0, 0};
        int logMemorySize = 0;

        int getLogFileSize() {
            return this.current;
        }

        LogFile(File dir, Repository repository) throws IOException {
            super(4096);
            this.repository = repository;
            boolean nolock = Boolean.getBoolean("NTNoLockFile");
            if (!nolock) {
                this.lockFile = new File(dir, LockPathname);
                if (!this.lockFile.createNewFile()) {
                    logmon.log(BasicLevel.FATAL, (Object)("NTransaction.init(): Either the server is already running, either you have to remove lock file: " + this.lockFile.getAbsolutePath()));
                    throw new IOException("Transaction already running.");
                }
                this.lockFile.deleteOnExit();
            }
            this.log = new Hashtable(LogMemoryCapacity);
            File logFilePN = new File(dir, "log");
            if (logFilePN.exists() && logFilePN.length() > 0L) {
                this.logFile = new RandomAccessFile(logFilePN, "r");
                try {
                    int optype = this.logFile.read();
                    while (optype == 3) {
                        optype = this.logFile.read();
                        while (optype == 4 || optype == 1 || optype == 2) {
                            String dirName = this.logFile.readUTF();
                            if (dirName.length() == 0) {
                                dirName = null;
                            }
                            String name = this.logFile.readUTF();
                            Object key = OperationKey.newKey(dirName, name);
                            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                                logmon.log(BasicLevel.DEBUG, (Object)("NTransaction.init(), OPERATION=" + optype + ", " + name));
                            }
                            Operation op = null;
                            if (optype == 1 || optype == 4) {
                                byte[] buf = new byte[this.logFile.readInt()];
                                this.logFile.readFully(buf);
                                op = Operation.alloc(optype, dirName, name, buf);
                                Operation old = this.log.put(key, op);
                                if (old != null) {
                                    old.free();
                                }
                            } else {
                                op = Operation.alloc(optype, dirName, name);
                                Operation old = this.log.put(key, op);
                                if (old != null) {
                                    if (old.type == 4) {
                                        op.type = 5;
                                    }
                                    old.free();
                                }
                            }
                            optype = this.logFile.read();
                        }
                        if (!logmon.isLoggable(BasicLevel.DEBUG)) continue;
                        logmon.log(BasicLevel.DEBUG, (Object)("NTransaction.init(), COMMIT=" + optype));
                    }
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.DEBUG, (Object)("NTransaction.init(), END=" + optype + ", " + this.logFile.getFilePointer()));
                    }
                    if (optype != 127) {
                        throw new IOException("Corrupted transaction log");
                    }
                }
                catch (IOException exc) {
                    throw exc;
                }
                finally {
                    this.logFile.close();
                }
                this.logFile = new RandomAccessFile(logFilePN, "rwd");
                this.garbage();
            } else {
                this.logFile = new RandomAccessFile(logFilePN, "rwd");
                this.logFile.setLength(MaxLogFileSize);
                this.current = 1;
                this.logFile.seek(0L);
                this.logFile.write(127);
            }
        }

        void writeUTF(String str) {
            int strlen = str.length();
            int newcount = this.count + strlen + 2;
            if (newcount > this.buf.length) {
                byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
                System.arraycopy(this.buf, 0, newbuf, 0, this.count);
                this.buf = newbuf;
            }
            this.buf[this.count++] = (byte)(strlen >>> 8 & 0xFF);
            this.buf[this.count++] = (byte)(strlen >>> 0 & 0xFF);
            str.getBytes(0, strlen, this.buf, this.count);
            this.count = newcount;
        }

        void writeInt(int v) throws IOException {
            int newcount = this.count + 4;
            if (newcount > this.buf.length) {
                byte[] newbuf = new byte[this.buf.length << 1];
                System.arraycopy(this.buf, 0, newbuf, 0, this.count);
                this.buf = newbuf;
            }
            this.buf[this.count++] = (byte)(v >>> 24 & 0xFF);
            this.buf[this.count++] = (byte)(v >>> 16 & 0xFF);
            this.buf[this.count++] = (byte)(v >>> 8 & 0xFF);
            this.buf[this.count++] = (byte)(v >>> 0 & 0xFF);
        }

        void commit(Hashtable ctxlog) throws IOException {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)"NTransaction.LogFile.commit()");
            }
            ++this.commitCount;
            Operation op = null;
            Enumeration e = ctxlog.elements();
            while (e.hasMoreElements()) {
                Operation old;
                op = (Operation)e.nextElement();
                if (op.type == 5) continue;
                this.write(op.type);
                if (op.dirName != null) {
                    this.writeUTF(op.dirName);
                } else {
                    this.write(emptyUTFString);
                }
                this.writeUTF(op.name);
                if (op.type == 1 || op.type == 4) {
                    this.logMemorySize += op.value.length;
                    this.writeInt(op.value.length);
                    this.write(op.value);
                }
                if ((old = this.log.put(OperationKey.newKey(op.dirName, op.name), op)) == null) continue;
                if (old.type == 1 || old.type == 4) {
                    this.logMemorySize -= old.value.length;
                }
                if (old.type == 4 && op.type == 2) {
                    op.type = 5;
                }
                old.free();
            }
            this.write(127);
            this.logFile.seek(this.current);
            this.logFile.write(this.buf, 0, this.count);
            this.logFile.seek(this.current - 1);
            this.logFile.write(3);
            this.current += this.count;
            this.reset();
            ctxlog.clear();
            if (this.current > MaxLogFileSize || this.logMemorySize > MaxLogMemorySize || this.garbageTimeOut > 0L && System.currentTimeMillis() > this.lastGarbageTime + this.garbageTimeOut) {
                this.garbage();
            }
        }

        private final void garbage() throws IOException {
            long end;
            long start = System.currentTimeMillis();
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)"NTransaction.LogFile.garbage() - begin");
            }
            ++this.garbageCount;
            Operation op = null;
            Enumeration e = this.log.elements();
            while (e.hasMoreElements()) {
                op = (Operation)e.nextElement();
                if (op.type == 1 || op.type == 4) {
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, LogFile.Save (" + op.dirName + '/' + op.name + ')'));
                    }
                    this.repository.save(op.dirName, op.name, op.value);
                } else if (op.type == 2) {
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, LogFile.Delete (" + op.dirName + '/' + op.name + ')'));
                    }
                    this.repository.delete(op.dirName, op.name);
                }
                op.free();
            }
            this.log.clear();
            this.logMemorySize = 0;
            this.repository.commit();
            this.current = 1;
            this.logFile.seek(0L);
            this.logFile.write(127);
            this.lastGarbageTime = end = System.currentTimeMillis();
            this.garbageTime += end - start;
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("NTransaction.LogFile.garbage() - end: " + (end - start)));
            }
        }

        void stop() {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)"NTransaction.LogFile, stops");
            }
            try {
                this.garbage();
                this.logFile.close();
                this.repository.close();
            }
            catch (IOException exc) {
                logmon.log(BasicLevel.WARN, (Object)"NTransaction.LogFile, can't close logfile", (Throwable)exc);
            }
            if (this.lockFile != null && !this.lockFile.delete()) {
                logmon.log(BasicLevel.FATAL, (Object)("NTransaction.LogFile, - can't delete lockfile: " + this.lockFile.getAbsolutePath()));
            }
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)"NTransaction.LogFile, stopped.");
            }
        }
    }

    private class GarbageTask
    extends TimerTask {
        private GarbageTask() {
            if (NTransaction.this.timer == null) {
                NTransaction.this.timer = new Timer();
            }
            if (NTransaction.this.logFile.garbageTimeOut > 0L) {
                try {
                    NTransaction.this.timer.schedule(this, NTransaction.this.logFile.garbageTimeOut);
                }
                catch (Exception exc) {
                    logmon.log(BasicLevel.ERROR, (Object)"NTransaction, cannot schedule garbage task ", (Throwable)exc);
                }
            }
        }

        public void run() {
            if (NTransaction.this.logFile.garbageTimeOut > 0L) {
                if (System.currentTimeMillis() > NTransaction.this.logFile.lastGarbageTime + NTransaction.this.logFile.garbageTimeOut) {
                    NTransaction.this.garbage();
                }
                try {
                    this.timer.schedule(this, NTransaction.this.logFile.garbageTimeOut);
                }
                catch (Exception exc) {
                    logmon.log(BasicLevel.ERROR, (Object)"NTransaction, cannot schedule garbage task ", (Throwable)exc);
                }
            }
        }
    }
}

