/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.IOException;
import javax.management.ObjectName;
import org.apache.jk.apr.AprImpl;
import org.apache.jk.common.MsgAjp;
import org.apache.jk.core.JkChannel;
import org.apache.jk.core.JkHandler;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.C2BConverter;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.modeler.Registry;

public class JniHandler
extends JkHandler {
    protected AprImpl apr;
    protected long nativeJkHandlerP;
    protected String jkHome;
    public static final int JK_HANDLE_JNI_DISPATCH = 21;
    public static final int JK_HANDLE_SHM_DISPATCH = 22;
    public static final int MSG_NOTE = 0;
    public static final int MB_NOTE = 2;
    private boolean paused = false;
    private static Log log = LogFactory.getLog(JniHandler.class);

    public void setJkHome(String s) {
        this.jkHome = s;
    }

    public String getJkHome() {
        return this.jkHome;
    }

    public void init() throws IOException {
    }

    protected void initNative(String nativeComponentName) {
        this.apr = (AprImpl)this.wEnv.getHandler("apr");
        if (this.apr == null) {
            try {
                this.apr = new AprImpl();
                this.wEnv.addHandler("apr", this.apr);
                this.apr.init();
                if (this.oname != null) {
                    ObjectName aprname = new ObjectName(this.oname.getDomain() + ":type=JkHandler, name=apr");
                    Registry.getRegistry(null, null).registerComponent((Object)this.apr, aprname, null);
                }
            }
            catch (Throwable t) {
                log.debug("Can't load apr", t);
                this.apr = null;
            }
        }
        if (this.apr == null || !this.apr.isLoaded()) {
            if (log.isDebugEnabled()) {
                log.debug("No apr, disabling jni proxy ");
            }
            this.apr = null;
            return;
        }
        try {
            long xEnv = this.apr.getJkEnv();
            this.nativeJkHandlerP = this.apr.getJkHandler(xEnv, nativeComponentName);
            if (this.nativeJkHandlerP == 0L) {
                log.debug("Component not found, creating it " + nativeComponentName);
                this.nativeJkHandlerP = this.apr.createJkHandler(xEnv, nativeComponentName);
            }
            log.debug("Native proxy " + this.nativeJkHandlerP);
            this.apr.releaseJkEnv(xEnv);
        }
        catch (Throwable t) {
            this.apr = null;
            log.info("Error calling apr ", t);
        }
    }

    public void appendString(Msg msg, String s, C2BConverter charsetDecoder) throws IOException {
        ByteChunk bc = charsetDecoder.getByteChunk();
        charsetDecoder.recycle();
        charsetDecoder.convert(s);
        charsetDecoder.flushBuffer();
        msg.appendByteChunk(bc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() throws Exception {
        JniHandler jniHandler = this;
        synchronized (jniHandler) {
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws Exception {
        JniHandler jniHandler = this;
        synchronized (jniHandler) {
            this.paused = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsgContext createMsgContext() {
        if (this.nativeJkHandlerP == 0L || this.apr == null) {
            return null;
        }
        JniHandler jniHandler = this;
        synchronized (jniHandler) {
            try {
                while (this.paused) {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        try {
            MsgContext msgCtx = new MsgContext();
            MsgAjp msg = new MsgAjp();
            msgCtx.setSource((JkChannel)((Object)this));
            msgCtx.setWorkerEnv(this.wEnv);
            msgCtx.setNext(this);
            msgCtx.setMsg(0, msg);
            C2BConverter c2b = new C2BConverter("iso-8859-1");
            msgCtx.setConverter(c2b);
            MessageBytes tmpMB = MessageBytes.newInstance();
            msgCtx.setNote(2, tmpMB);
            return msgCtx;
        }
        catch (Exception ex) {
            log.error("Can't create endpoint", ex);
            return null;
        }
    }

    public void setNativeAttribute(String name, String val) throws IOException {
        if (this.apr == null) {
            return;
        }
        if (this.nativeJkHandlerP == 0L) {
            log.error("Unitialized component " + name + " " + val);
            return;
        }
        long xEnv = this.apr.getJkEnv();
        this.apr.jkSetAttribute(xEnv, this.nativeJkHandlerP, name, val);
        this.apr.releaseJkEnv(xEnv);
    }

    public void initJkComponent() throws IOException {
        if (this.apr == null) {
            return;
        }
        if (this.nativeJkHandlerP == 0L) {
            log.error("Unitialized component ");
            return;
        }
        long xEnv = this.apr.getJkEnv();
        this.apr.jkInit(xEnv, this.nativeJkHandlerP);
        this.apr.releaseJkEnv(xEnv);
    }

    public void destroyJkComponent() throws IOException {
        if (this.apr == null) {
            return;
        }
        if (this.nativeJkHandlerP == 0L) {
            log.error("Unitialized component ");
            return;
        }
        long xEnv = this.apr.getJkEnv();
        this.apr.jkDestroy(xEnv, this.nativeJkHandlerP);
        this.apr.releaseJkEnv(xEnv);
    }

    protected void setNativeEndpoint(MsgContext msgCtx) {
        long xEnv = this.apr.getJkEnv();
        msgCtx.setJniEnv(xEnv);
        long epP = this.apr.createJkHandler(xEnv, "endpoint");
        log.debug("create ep " + epP);
        if (epP == 0L) {
            return;
        }
        this.apr.jkInit(xEnv, epP);
        msgCtx.setJniContext(epP);
    }

    protected void recycleNative(MsgContext ep) {
        this.apr.jkRecycle(ep.getJniEnv(), ep.getJniContext());
    }

    protected int nativeDispatch(Msg msg, MsgContext ep, int code, int raw) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Sending packet " + code + " " + raw);
        }
        if (raw == 0) {
            msg.end();
            if (log.isTraceEnabled()) {
                msg.dump("OUT:");
            }
        }
        long xEnv = ep.getJniEnv();
        long nativeContext = ep.getJniContext();
        if (nativeContext == 0L || xEnv == 0L) {
            this.setNativeEndpoint(ep);
            xEnv = ep.getJniEnv();
            nativeContext = ep.getJniContext();
        }
        if (xEnv == 0L || nativeContext == 0L || this.nativeJkHandlerP == 0L) {
            log.error("invokeNative: Null pointer ");
            return -1;
        }
        int status = AprImpl.jkInvoke(xEnv, this.nativeJkHandlerP, nativeContext, code, msg.getBuffer(), 0, msg.getLen(), raw);
        if (status != 0 && status != 2) {
            log.error("nativeDispatch: error " + status, new Throwable());
        }
        if (log.isDebugEnabled()) {
            log.debug("Sending packet - done " + status);
        }
        return status;
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        long xEnv = ep.getJniEnv();
        int type = ep.getType();
        int status = this.nativeDispatch(msg, ep, type, 0);
        this.apr.jkRecycle(xEnv, ep.getJniContext());
        this.apr.releaseJkEnv(xEnv);
        return status;
    }
}

