/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.component.bean.AnnotationExpressionFactory;
import org.apache.camel.language.LanguageAnnotation;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ObjectHelper;

public class DefaultAnnotationExpressionFactory
implements AnnotationExpressionFactory {
    public Expression createExpression(CamelContext camelContext, Annotation annotation, LanguageAnnotation languageAnnotation, Class expressionReturnType) {
        String languageName = languageAnnotation.language();
        if (languageName == null) {
            throw new IllegalArgumentException("Cannot determine the language from the annotation: " + annotation);
        }
        Language language = camelContext.resolveLanguage(languageName);
        if (language == null) {
            throw new IllegalArgumentException("Cannot find the language: " + languageName + " on the classpath");
        }
        String expression = this.getExpressionFromAnnotation(annotation);
        return language.createExpression(expression);
    }

    protected String getExpressionFromAnnotation(Annotation annotation) {
        try {
            Method method = annotation.getClass().getMethod("value", new Class[0]);
            Object value = ObjectHelper.invokeMethod(method, annotation, new Object[0]);
            if (value == null) {
                throw new IllegalArgumentException("Cannot determine the expression from the annotation: " + annotation);
            }
            return value.toString();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot determine the expression of the annotation: " + annotation + " as it does not have a value() method");
        }
    }
}

