/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="dataFormat")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DataFormatDefinition
extends IdentifiedType {
    @XmlTransient
    private DataFormat dataFormat;
    @XmlTransient
    private String dataFormatName;

    public DataFormatDefinition() {
    }

    public DataFormatDefinition(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    protected DataFormatDefinition(String dataFormatName) {
        this.dataFormatName = dataFormatName;
    }

    public static DataFormat getDataFormat(RouteContext routeContext, DataFormatDefinition type, String ref) {
        if (type == null) {
            ObjectHelper.notNull(ref, "ref or dataFormat");
            DataFormat dataFormat = DataFormatDefinition.lookup(routeContext, ref, DataFormat.class);
            if (dataFormat == null) {
                type = DataFormatDefinition.lookup(routeContext, ref, DataFormatDefinition.class);
                if (type == null) {
                    type = routeContext.getDataFormat(ref);
                }
                if (type != null) {
                    dataFormat = type.getDataFormat(routeContext);
                }
            }
            if (dataFormat == null) {
                throw new IllegalArgumentException("Cannot find data format in registry with ref: " + ref);
            }
            return dataFormat;
        }
        return type.getDataFormat(routeContext);
    }

    private static <T> T lookup(RouteContext routeContext, String ref, Class<T> type) {
        try {
            return routeContext.lookup(ref, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    public DataFormat getDataFormat(RouteContext routeContext) {
        if (this.dataFormat == null) {
            this.dataFormat = this.createDataFormat(routeContext);
            ObjectHelper.notNull(this.dataFormat, "dataFormat");
            this.configureDataFormat(this.dataFormat);
        }
        return this.dataFormat;
    }

    protected DataFormat createDataFormat(RouteContext routeContext) {
        if (this.dataFormatName != null) {
            Class type = routeContext.getCamelContext().getClassResolver().resolveClass(this.dataFormatName);
            if (type == null) {
                throw new IllegalArgumentException("The class " + this.dataFormatName + " is not on the classpath! Cannot use the dataFormat " + this);
            }
            return (DataFormat)ObjectHelper.newInstance(type);
        }
        return null;
    }

    protected void configureDataFormat(DataFormat dataFormat) {
    }

    protected void setProperty(Object bean, String name, Object value) {
        try {
            IntrospectionSupport.setProperty(bean, name, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to set property: " + name + " on: " + bean + ". Reason: " + e, e);
        }
    }

    public String getDataFormatName() {
        return this.dataFormatName;
    }

    public void setDataFormatName(String dataFormatName) {
        this.dataFormatName = dataFormatName;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }
}

