/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mail.ContentTypeResolver;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.CollectionHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailBinding {
    private static final transient Log LOG = LogFactory.getLog(MailBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;
    private ContentTypeResolver contentTypeResolver;

    public MailBinding() {
        this.headerFilterStrategy = new DefaultHeaderFilterStrategy();
    }

    public MailBinding(HeaderFilterStrategy headerFilterStrategy, ContentTypeResolver contentTypeResolver) {
        this.headerFilterStrategy = headerFilterStrategy;
        this.contentTypeResolver = contentTypeResolver;
    }

    public void populateMailMessage(MailEndpoint endpoint, MimeMessage mimeMessage, Exchange exchange) throws MessagingException, IOException {
        if (MailBinding.hasRecipientHeaders(exchange)) {
            this.setRecipientFromCamelMessage(mimeMessage, exchange);
        } else {
            this.setRecipientFromEndpointConfiguration(mimeMessage, endpoint);
        }
        if (mimeMessage.getAllRecipients() == null) {
            throw new IllegalArgumentException("The mail message does not have any recipients set.");
        }
        this.appendHeadersFromCamelMessage(mimeMessage, endpoint.getConfiguration(), exchange);
        if (MailBinding.empty(mimeMessage.getFrom())) {
            String from = endpoint.getConfiguration().getFrom();
            mimeMessage.setFrom((Address)new InternetAddress(from));
        }
        if (MailBinding.hasAlternativeBody(endpoint.getConfiguration(), exchange)) {
            this.createMultipartAlternativeMessage(mimeMessage, endpoint.getConfiguration(), exchange);
        } else if (exchange.getIn().hasAttachments()) {
            this.appendAttachmentsFromCamel(mimeMessage, endpoint.getConfiguration(), exchange);
        } else {
            this.populateContentOnMimeMessage(mimeMessage, endpoint.getConfiguration(), exchange);
        }
    }

    protected String determineContentType(MailConfiguration configuration, Exchange exchange) {
        String contentType = configuration.getContentType();
        if (exchange.getIn().getHeader("contentType") != null) {
            contentType = (String)exchange.getIn().getHeader("contentType", String.class);
        } else if (exchange.getIn().getHeader("Content-Type") != null) {
            contentType = (String)exchange.getIn().getHeader("Content-Type", String.class);
        }
        if (contentType != null && contentType.contains(";")) {
            String before = ObjectHelper.before((String)contentType, (String)";");
            String after = ObjectHelper.after((String)contentType, (String)";");
            if (after != null) {
                String charset = ObjectHelper.after((String)after, (String)"=");
                after = (charset = this.determineCharSet(configuration, charset)) != null ? "charset=" + charset : null;
            }
            if (before != null && after == null) {
                contentType = before.trim();
            } else if (before != null && after != null) {
                contentType = before.trim() + "; " + after;
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Determined Content-Type: " + contentType));
        }
        return contentType;
    }

    protected String determineCharSet(MailConfiguration configuration, String charset) {
        boolean supported;
        if (charset == null) {
            return null;
        }
        try {
            supported = Charset.isSupported(charset);
        }
        catch (IllegalCharsetNameException e) {
            supported = false;
        }
        if (supported) {
            return charset;
        }
        if (configuration.isIgnoreUnsupportedCharset()) {
            LOG.warn((Object)("Charset: " + charset + " is not supported, will fallback to use platform default instead."));
            return null;
        }
        return charset;
    }

    protected String populateContentOnMimeMessage(MimeMessage part, MailConfiguration configuration, Exchange exchange) throws MessagingException, IOException {
        String contentType = this.determineContentType(configuration, exchange);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Using Content-Type " + contentType + " for MimeMessage: " + part));
        }
        ByteArrayDataSource ds = new ByteArrayDataSource((String)exchange.getIn().getBody(String.class), contentType);
        part.setDataHandler(new DataHandler((DataSource)ds));
        part.setHeader("Content-Type", contentType);
        return contentType;
    }

    protected String populateContentOnBodyPart(BodyPart part, MailConfiguration configuration, Exchange exchange) throws MessagingException, IOException {
        String contentType = this.determineContentType(configuration, exchange);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Using Content-Type " + contentType + " for BodyPart: " + part));
        }
        ByteArrayDataSource ds = new ByteArrayDataSource((String)exchange.getIn().getBody(String.class), contentType);
        part.setDataHandler(new DataHandler((DataSource)ds));
        part.setHeader("Content-Type", contentType);
        return contentType;
    }

    public Object extractBodyFromMail(Exchange exchange, Message message) {
        try {
            return message.getContent();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Failed to extract body due to: " + e.getMessage() + ". Exchange: " + exchange + ". Message: " + message, (Throwable)e);
        }
    }

    protected void appendHeadersFromCamelMessage(MimeMessage mimeMessage, MailConfiguration configuration, Exchange exchange) throws MessagingException {
        for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
            String headerName = (String)entry.getKey();
            Object headerValue = entry.getValue();
            if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(headerName, headerValue, exchange) || MailBinding.isRecipientHeader(headerName) || headerName.equalsIgnoreCase(configuration.getAlternativeBodyHeader())) continue;
            if (ObjectConverter.isCollection(headerValue)) {
                Iterator iter = ObjectHelper.createIterator(headerValue);
                while (iter.hasNext()) {
                    Object value = iter.next();
                    mimeMessage.addHeader(headerName, MailBinding.asString(exchange, value));
                }
                continue;
            }
            mimeMessage.setHeader(headerName, MailBinding.asString(exchange, headerValue));
        }
    }

    private void setRecipientFromCamelMessage(MimeMessage mimeMessage, Exchange exchange) throws MessagingException {
        for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
            String headerName = (String)entry.getKey();
            Object headerValue = entry.getValue();
            if (headerValue == null || !MailBinding.isRecipientHeader(headerName)) continue;
            if (ObjectConverter.isCollection(headerValue)) {
                Iterator iter = ObjectHelper.createIterator(headerValue);
                while (iter.hasNext()) {
                    Object recipient = iter.next();
                    MailBinding.appendRecipientToMimeMessage(mimeMessage, headerName, MailBinding.asString(exchange, recipient));
                }
                continue;
            }
            MailBinding.appendRecipientToMimeMessage(mimeMessage, headerName, MailBinding.asString(exchange, headerValue));
        }
    }

    protected void setRecipientFromEndpointConfiguration(MimeMessage mimeMessage, MailEndpoint endpoint) throws MessagingException {
        Map<Message.RecipientType, String> recipients = endpoint.getConfiguration().getRecipients();
        if (recipients.containsKey(Message.RecipientType.TO)) {
            MailBinding.appendRecipientToMimeMessage(mimeMessage, Message.RecipientType.TO.toString(), recipients.get(Message.RecipientType.TO));
        }
        if (recipients.containsKey(Message.RecipientType.CC)) {
            MailBinding.appendRecipientToMimeMessage(mimeMessage, Message.RecipientType.CC.toString(), recipients.get(Message.RecipientType.CC));
        }
        if (recipients.containsKey(Message.RecipientType.BCC)) {
            MailBinding.appendRecipientToMimeMessage(mimeMessage, Message.RecipientType.BCC.toString(), recipients.get(Message.RecipientType.BCC));
        }
    }

    protected void appendAttachmentsFromCamel(MimeMessage mimeMessage, MailConfiguration configuration, Exchange exchange) throws MessagingException, IOException {
        mimeMessage.setContent((Multipart)this.createMixedMultipartAttachments(configuration, exchange));
    }

    private MimeMultipart createMixedMultipartAttachments(MailConfiguration configuration, Exchange exchange) throws MessagingException, IOException {
        String partDisposition;
        MimeMultipart multipart = new MimeMultipart();
        multipart.setSubType("mixed");
        this.addBodyToMultipart(configuration, multipart, exchange);
        String string = partDisposition = configuration.isUseInlineAttachments() ? "inline" : "attachment";
        if (exchange.getIn().hasAttachments()) {
            this.addAttachmentsToMultipart(multipart, partDisposition, exchange);
        }
        return multipart;
    }

    protected void addAttachmentsToMultipart(MimeMultipart multipart, String partDisposition, Exchange exchange) throws MessagingException {
        LOG.trace((Object)"Adding attachments +++ start +++");
        int i = 0;
        for (Map.Entry entry : exchange.getIn().getAttachments().entrySet()) {
            String attachmentFilename = (String)entry.getKey();
            DataHandler handler = (DataHandler)entry.getValue();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Attachment #" + i + ": Disposition: " + partDisposition));
                LOG.trace((Object)("Attachment #" + i + ": DataHandler: " + handler));
                LOG.trace((Object)("Attachment #" + i + ": FileName: " + attachmentFilename));
            }
            if (handler != null) {
                if (this.shouldAddAttachment(exchange, attachmentFilename, handler)) {
                    MimeBodyPart messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setDataHandler(handler);
                    if (attachmentFilename.toLowerCase().startsWith("cid:")) {
                        messageBodyPart.addHeader("Content-ID", attachmentFilename.substring(4));
                    }
                    messageBodyPart.setFileName(attachmentFilename);
                    LOG.trace((Object)("Attachment #" + i + ": ContentType: " + messageBodyPart.getContentType()));
                    if (this.contentTypeResolver != null) {
                        String contentType = this.contentTypeResolver.resolveContentType(attachmentFilename);
                        LOG.trace((Object)("Attachment #" + i + ": Using content type resolver: " + this.contentTypeResolver + " resolved content type as: " + contentType));
                        if (contentType != null) {
                            String value = contentType + "; name=" + attachmentFilename;
                            messageBodyPart.setHeader("Content-Type", value);
                            LOG.trace((Object)("Attachment #" + i + ": ContentType: " + messageBodyPart.getContentType()));
                        }
                    }
                    messageBodyPart.setDisposition(partDisposition);
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                } else {
                    LOG.trace((Object)"shouldAddAttachment: false");
                }
            } else {
                LOG.warn((Object)("Cannot add attachment: " + attachmentFilename + " as DataHandler is null"));
            }
            ++i;
        }
        LOG.trace((Object)"Adding attachments +++ done +++");
    }

    protected void createMultipartAlternativeMessage(MimeMessage mimeMessage, MailConfiguration configuration, Exchange exchange) throws MessagingException, IOException {
        MimeMultipart multipartAlternative = new MimeMultipart("alternative");
        mimeMessage.setContent((Multipart)multipartAlternative);
        MimeBodyPart plainText = new MimeBodyPart();
        plainText.setText(MailBinding.getAlternativeBody(configuration, exchange));
        exchange.getIn().removeHeader(configuration.getAlternativeBodyHeader());
        multipartAlternative.addBodyPart((BodyPart)plainText);
        if (!exchange.getIn().hasAttachments()) {
            this.addBodyToMultipart(configuration, multipartAlternative, exchange);
        } else if (!configuration.isUseInlineAttachments()) {
            MimeBodyPart mixedAttachments = new MimeBodyPart();
            mixedAttachments.setContent((Multipart)this.createMixedMultipartAttachments(configuration, exchange));
            multipartAlternative.addBodyPart((BodyPart)mixedAttachments);
        } else {
            MimeMultipart multipartRelated = new MimeMultipart("related");
            MimeBodyPart related = new MimeBodyPart();
            related.setContent((Multipart)multipartRelated);
            multipartAlternative.addBodyPart((BodyPart)related);
            this.addBodyToMultipart(configuration, multipartRelated, exchange);
            this.addAttachmentsToMultipart(multipartRelated, "inline", exchange);
        }
    }

    protected void addBodyToMultipart(MailConfiguration configuration, MimeMultipart activeMultipart, Exchange exchange) throws MessagingException, IOException {
        MimeBodyPart bodyMessage = new MimeBodyPart();
        this.populateContentOnBodyPart((BodyPart)bodyMessage, configuration, exchange);
        activeMultipart.addBodyPart((BodyPart)bodyMessage);
    }

    protected boolean shouldAddAttachment(Exchange exchange, String attachmentFilename, DataHandler handler) {
        return true;
    }

    protected Map<String, Object> extractHeadersFromMail(Message mailMessage, Exchange exchange) throws MessagingException {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        Enumeration names = mailMessage.getAllHeaders();
        while (names.hasMoreElements()) {
            Header header = (Header)names.nextElement();
            String[] value = mailMessage.getHeader(header.getName());
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(header.getName(), (Object)value, exchange)) continue;
            if (value.length == 1) {
                CollectionHelper.appendValue(answer, (Object)header.getName(), (Object)value[0]);
                continue;
            }
            CollectionHelper.appendValue(answer, (Object)header.getName(), (Object)value);
        }
        return answer;
    }

    private static void appendRecipientToMimeMessage(MimeMessage mimeMessage, String type, String recipient) throws MessagingException {
        String[] lines;
        for (String line : lines = recipient.split("[,|;]")) {
            line = line.trim();
            mimeMessage.addRecipients(MailBinding.asRecipientType(type), line);
        }
    }

    private static boolean hasRecipientHeaders(Exchange exchange) {
        for (String key : exchange.getIn().getHeaders().keySet()) {
            if (!MailBinding.isRecipientHeader(key)) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasAlternativeBody(MailConfiguration configuration, Exchange exchange) {
        return MailBinding.getAlternativeBody(configuration, exchange) != null;
    }

    protected static String getAlternativeBody(MailConfiguration configuration, Exchange exchange) {
        String alternativeBodyHeader = configuration.getAlternativeBodyHeader();
        return (String)exchange.getIn().getHeader(alternativeBodyHeader, String.class);
    }

    private static boolean isRecipientHeader(String key) {
        if (Message.RecipientType.TO.toString().equalsIgnoreCase(key)) {
            return true;
        }
        if (Message.RecipientType.CC.toString().equalsIgnoreCase(key)) {
            return true;
        }
        return Message.RecipientType.BCC.toString().equalsIgnoreCase(key);
    }

    private static Message.RecipientType asRecipientType(String type) {
        if (Message.RecipientType.TO.toString().equalsIgnoreCase(type)) {
            return Message.RecipientType.TO;
        }
        if (Message.RecipientType.CC.toString().equalsIgnoreCase(type)) {
            return Message.RecipientType.CC;
        }
        if (Message.RecipientType.BCC.toString().equalsIgnoreCase(type)) {
            return Message.RecipientType.BCC;
        }
        throw new IllegalArgumentException("Unknown recipient type: " + type);
    }

    private static boolean empty(Address[] addresses) {
        return addresses == null || addresses.length == 0;
    }

    private static String asString(Exchange exchange, Object value) {
        return (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, value);
    }
}

