/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.util.ExchangeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteFileProducer<T>
extends GenericFileProducer<T>
implements ServicePoolAware {
    private boolean loggedIn;

    protected RemoteFileProducer(RemoteFileEndpoint<T> endpoint, RemoteFileOperations<T> operations) {
        super(endpoint, operations);
    }

    protected String getFileSeparator() {
        return "/";
    }

    protected String normalizePath(String name) {
        return name;
    }

    public void process(Exchange exchange) throws Exception {
        Exchange remoteExchange = this.getEndpoint().createExchange(exchange);
        this.processExchange(remoteExchange);
        ExchangeHelper.copyResults((Exchange)exchange, (Exchange)remoteExchange);
    }

    protected void handleFailedWrite(Exchange exchange, Exception exception) throws Exception {
        this.loggedIn = false;
        if (!this.isStopping() && !this.isStopped()) {
            this.log.debug((Object)"Exception occured during processing. ", (Throwable)exception);
            this.disconnect();
            throw exception;
        }
        this.log.debug((Object)("Exception occured during stopping: " + exception.getMessage()));
    }

    public void disconnect() throws IOException {
        this.loggedIn = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Disconnecting from: " + this.getEndpoint()));
        }
        ((RemoteFileOperations)this.operations).disconnect();
    }

    protected void preWriteCheck() throws Exception {
        this.connectIfNecessary();
        if (!this.loggedIn) {
            String message = "Cannot connect/login to: " + ((RemoteFileEndpoint)this.getEndpoint()).remoteServerInformation();
            throw new GenericFileOperationFailedException(message);
        }
    }

    protected void doStart() throws Exception {
        this.log.debug((Object)"Starting");
        super.doStart();
    }

    protected void doStop() throws Exception {
        try {
            this.disconnect();
        }
        catch (Exception e) {
            this.log.debug((Object)("Exception occured during disconnecting from: " + this.getEndpoint() + " " + e.getMessage()));
        }
        super.doStop();
    }

    protected void connectIfNecessary() throws IOException {
        if (!((RemoteFileOperations)this.operations).isConnected() || !this.loggedIn) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Not already connected/logged in. Connecting to: " + this.getEndpoint()));
            }
            RemoteFileOperations rfo = (RemoteFileOperations)this.operations;
            RemoteFileEndpoint rfe = (RemoteFileEndpoint)this.getEndpoint();
            RemoteFileConfiguration conf = (RemoteFileConfiguration)rfe.getConfiguration();
            this.loggedIn = rfo.connect(conf);
            if (!this.loggedIn) {
                return;
            }
            this.log.info((Object)("Connected and logged in to: " + this.getEndpoint()));
        }
    }

    public boolean isSingleton() {
        return false;
    }
}

