/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.manager;

import java.io.Serializable;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.jonas.lib.management.extensions.cluster.ClusterManagement;
import org.ow2.jonas.lib.management.extensions.clusterdaemon.ClusterdaemonManagement;
import org.ow2.jonas.lib.management.extensions.domain.DomainManagement;
import org.ow2.jonas.lib.management.extensions.server.ServerManagement;
import org.ow2.jonas.lib.management.extensions.server.ServerMonitoring;
import org.ow2.jonas.management.extensions.base.api.J2EEMBeanAttributeInfo;
import org.ow2.jonas.management.extensions.base.api.ManagementException;
import org.ow2.jonas.management.extensions.cluster.api.ICluster;
import org.ow2.jonas.management.extensions.clusterdaemon.api.IClusterdaemon;
import org.ow2.jonas.management.extensions.domain.api.IDomain;
import org.ow2.jonas.management.extensions.server.api.IServer;
import org.ow2.jonas.management.extensions.server.api.IServerManagement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ManagementEntryPoint
implements IDomain,
IServer,
IServerManagement,
IClusterdaemon,
ICluster,
Serializable {
    private static final long serialVersionUID = 1L;
    private static ManagementEntryPoint unique = null;
    private static IDomain domainManagement = null;
    private static IServer serverMonitor = null;
    private static IServerManagement serverManagement = null;
    private static IClusterdaemon clusterdaemonManagement = null;
    private static ICluster clusterManagement = null;

    public static synchronized ManagementEntryPoint getInstance() {
        if (unique == null) {
            unique = new ManagementEntryPoint();
        }
        return unique;
    }

    private ManagementEntryPoint() {
        domainManagement = new DomainManagement();
        serverMonitor = new ServerMonitoring();
        serverManagement = new ServerManagement();
        clusterdaemonManagement = new ClusterdaemonManagement();
        clusterManagement = new ClusterManagement();
    }

    public String getDomainName() {
        return domainManagement.getDomainName();
    }

    public String getServerName() {
        return domainManagement.getServerName();
    }

    public String getServerHost() {
        return domainManagement.getServerHost();
    }

    public String getServerPort() {
        return domainManagement.getServerPort();
    }

    public boolean isMaster(String serverName) {
        return domainManagement.isMaster(serverName);
    }

    public boolean isMaster() {
        return domainManagement.isMaster();
    }

    public String[] getServerNames() {
        return domainManagement.getServerNames();
    }

    public String[] getClustersNames() {
        return domainManagement.getClustersNames();
    }

    public String[] getClusterDaemonNames() {
        return domainManagement.getClusterDaemonNames();
    }

    public String[] getClusters() {
        return domainManagement.getClusters();
    }

    public String[] getclusterDaemons() {
        return domainManagement.getclusterDaemons();
    }

    public void addServer(String serverName, String serverURL, String userName, String password, String clusterdaemon) {
        domainManagement.addServer(serverName, serverURL, userName, password, clusterdaemon);
    }

    public void removeServers(String[] serversToRemove) {
        domainManagement.removeServers(serversToRemove);
    }

    public void addCluster(String clusterName) {
        domainManagement.addCluster(clusterName);
    }

    public String getServerState(String serverName) {
        return domainManagement.getServerState(serverName);
    }

    public void startServer(String serverName) {
        this.startServer(serverName, false);
    }

    public void startServer(String serverName, boolean standby) {
        domainManagement.startServer(serverName, standby);
    }

    public void stopServer(String serverName) {
        this.stopServer(serverName, true);
    }

    public void stopServer(String serverName, boolean standby) {
        domainManagement.stopServer(serverName, standby);
    }

    public void haltServer(String serverName) {
        this.stopServer(serverName, false);
    }

    public String getServerClusterdaemon(String serverName) {
        return domainManagement.getServerClusterdaemon(serverName);
    }

    public String getClusterState(String clusterName) {
        return domainManagement.getClusterState(clusterName);
    }

    public String getClusterType(String clusterName) {
        return domainManagement.getClusterType(clusterName);
    }

    public String[] getServerNames(String clusterName) {
        return domainManagement.getServerNames(clusterName);
    }

    public String getJavaHome(String serverName) {
        return serverMonitor.getJavaHome(serverName);
    }

    public long getCurrentUsedMemory(String server) {
        return serverMonitor.getCurrentUsedMemory(server);
    }

    public String getServerVersion(String server) {
        return serverMonitor.getServerVersion(server);
    }

    public int getAllThreadsCount(String server) {
        return serverMonitor.getAllThreadsCount(server);
    }

    public Long getCurrentTotalMemory(String server) {
        return serverMonitor.getCurrentTotalMemory(server);
    }

    public String getConnectionUrl(String server) {
        return serverMonitor.getConnectionUrl(server);
    }

    public String getJonasBase(String server) {
        return serverMonitor.getJonasBase(server);
    }

    public String getJonasRoot(String server) {
        return serverMonitor.getJonasRoot(server);
    }

    public String getXprem(String server) {
        return serverMonitor.getXprem(server);
    }

    public String getDescription(String server) {
        return serverMonitor.getDescription(server);
    }

    public String getAutoBoot(String server) {
        return serverMonitor.getAutoBoot(server);
    }

    public String getJavaVendor(String server) {
        return serverMonitor.getJavaVendor(server);
    }

    public String getJavaVersion(String server) {
        return serverMonitor.getJavaVersion(server);
    }

    public String getProtocols(String server) {
        return serverMonitor.getProtocols(server);
    }

    public int getTotalBegunTransactions(String server) {
        return serverMonitor.getTotalBegunTransactions(server);
    }

    public int getTotalCommittedTransactions(String server) {
        return serverMonitor.getTotalCommittedTransactions(server);
    }

    public int getTotalExpiredTransactions(String server) {
        return serverMonitor.getTotalExpiredTransactions(server);
    }

    public int getTotalRolledbackTransactions(String server) {
        return serverMonitor.getTotalRolledbackTransactions(server);
    }

    public int getTotalCurrentTransactions(String server) {
        return serverMonitor.getTotalCurrentTransactions(server);
    }

    public long getBytesReceivedByConnectorTomcat(String server) {
        return serverMonitor.getBytesReceivedByConnectorTomcat(server);
    }

    public long getBytesSentByConnectorTomcat(String server) {
        return serverMonitor.getBytesSentByConnectorTomcat(server);
    }

    public int getCurrentThreadBusyByConnectorTomcat(String server) {
        return serverMonitor.getCurrentThreadBusyByConnectorTomcat(server);
    }

    public int getCurrentThreadCountByConnectorTomcat(String server) {
        return serverMonitor.getCurrentThreadCountByConnectorTomcat(server);
    }

    public int getErrorCountByConnectorTomcat(String server) {
        return serverMonitor.getErrorCountByConnectorTomcat(server);
    }

    public String getHostName(String serverName) {
        return serverMonitor.getHostName(serverName);
    }

    public int getMaxThreadsByConnectorTomcat(String server) {
        return serverMonitor.getMaxThreadsByConnectorTomcat(server);
    }

    public long getProcessingTimeByConnectorTomcat(String server) {
        return serverMonitor.getProcessingTimeByConnectorTomcat(server);
    }

    public int getRequestCountByConnectorTomcat(String server) {
        return serverMonitor.getRequestCountByConnectorTomcat(server);
    }

    public int getCurrentNumberOfEJB(String server) {
        return serverMonitor.getCurrentNumberOfEJB(server);
    }

    public int getCurrentNumberOfEntityBean(String server) {
        return serverMonitor.getCurrentNumberOfEntityBean(server);
    }

    public int getCurrentNumberOfMDB(String server) {
        return serverMonitor.getCurrentNumberOfMDB(server);
    }

    public int getCurrentNumberOfSBF(String server) {
        return serverMonitor.getCurrentNumberOfSBF(server);
    }

    public int getCurrentNumberOfSBL(String server) {
        return serverMonitor.getCurrentNumberOfSBL(server);
    }

    public String[] getControlledServersNames(String clusterdaemonName) {
        return clusterdaemonManagement.getControlledServersNames(clusterdaemonName);
    }

    public boolean isRunning(String clusterdaemonName) {
        return clusterdaemonManagement.isRunning(clusterdaemonName);
    }

    public String getClusterdaemonState(String clusterdaemonName) {
        return clusterdaemonManagement.getClusterdaemonState(clusterdaemonName);
    }

    public boolean startServer(String clusterdaemonName, String serverName) {
        return clusterdaemonManagement.startServer(clusterdaemonName, serverName);
    }

    public boolean stopServer(String clusterdaemonName, String serverName) {
        return clusterdaemonManagement.stopServer(clusterdaemonName, serverName);
    }

    public void addServer(String clusterDaemonName, String serverName, String description, String jonasRoot, String jonasBase, String javaHome, String xprem, String autoBoot, String jonasCmd, String saveIt) {
        clusterdaemonManagement.addServer(clusterDaemonName, serverName, description, jonasRoot, jonasBase, javaHome, xprem, autoBoot, jonasCmd, saveIt);
    }

    public String getOperatingSystemAvailableProcessors(String clusterDaemonName) {
        return clusterdaemonManagement.getOperatingSystemAvailableProcessors(clusterDaemonName);
    }

    public String getOperatingSystemName(String clusterDaemonName) {
        return clusterdaemonManagement.getOperatingSystemName(clusterDaemonName);
    }

    public String getOperatingSystemVersion(String clusterDaemonName) {
        return clusterdaemonManagement.getOperatingSystemVersion(clusterDaemonName);
    }

    public String getRunTimeSpecVendor(String clusterDaemonName) {
        return clusterdaemonManagement.getRunTimeSpecVendor(clusterDaemonName);
    }

    public String getRunTimeSpecVersion(String clusterDaemonName) {
        return clusterdaemonManagement.getRunTimeSpecVersion(clusterDaemonName);
    }

    public String getRunTimeVmName(String clusterDaemonName) {
        return clusterdaemonManagement.getRunTimeVmName(clusterDaemonName);
    }

    public String getRunTimeVmVendor(String clusterDaemonName) {
        return clusterdaemonManagement.getRunTimeVmVendor(clusterDaemonName);
    }

    public String getRunTimeVmVersion(String clusterDaemonName) {
        return clusterdaemonManagement.getRunTimeVmVersion(clusterDaemonName);
    }

    public String getOperatingSystemArch(String clusterDaemonName) {
        return clusterdaemonManagement.getOperatingSystemArch(clusterDaemonName);
    }

    public String getVmCurrentUsedMemory(String clusterDaemonName) {
        return clusterdaemonManagement.getVmCurrentUsedMemory(clusterDaemonName);
    }

    public String getVmTotalMemory(String clusterDaemonName) {
        return clusterdaemonManagement.getVmTotalMemory(clusterDaemonName);
    }

    public String getVmCurrentUsedHeapMemory(String clusterDaemonName) {
        return clusterdaemonManagement.getVmCurrentUsedHeapMemory(clusterDaemonName);
    }

    public String getVmCurrentUsedNonHeapMemory(String clusterDaemonName) {
        return clusterdaemonManagement.getVmCurrentUsedNonHeapMemory(clusterDaemonName);
    }

    public String getOsCurrentUsedSpace(String clusterDaemonName) {
        return clusterdaemonManagement.getOsCurrentUsedSpace(clusterDaemonName);
    }

    public String getOsTotalSpace(String clusterDaemonName) {
        return clusterdaemonManagement.getOsTotalSpace(clusterDaemonName);
    }

    public void removeServer(String clusterDaemonName, String serverName, String saveIt) {
        clusterdaemonManagement.removeServer(clusterDaemonName, serverName, saveIt);
    }

    public void startAllServers(String clusterDaemonName, String otherParams) {
        clusterdaemonManagement.startAllServers(clusterDaemonName, otherParams);
    }

    public void stopAllServers(String clusterDaemonName, String otherParams) {
        clusterdaemonManagement.stopAllServers(clusterDaemonName, otherParams);
    }

    public void addServerToCluster(String clusterName, String serverName, String clusterDaemon, String serverURL) {
        clusterManagement.addServerToCluster(clusterName, serverName, clusterDaemon, serverURL);
    }

    public void startAllServers(String clusterName) {
        clusterManagement.startAllServers(clusterName);
    }

    public void stopAllServers(String clusterName) {
        clusterManagement.stopAllServers(clusterName);
    }

    public String getMcastAddr(String clusterName) {
        return clusterManagement.getMcastAddr(clusterName);
    }

    public int getMcastPort(String clusterName) {
        return clusterManagement.getMcastPort(clusterName);
    }

    public int getDelayToRefresh(String clusterName) {
        return clusterManagement.getDelayToRefresh(clusterName);
    }

    public String[] getServersNotInCluster(String clusterName) {
        return domainManagement.getServersNotInCluster(clusterName);
    }

    public List<List<String>> getServerThreadsInformation(String serverName) throws Exception {
        return serverManagement.getServerThreadsInformation(serverName);
    }

    public List<List<String>> getServerThreadsInformation(String jmxUrl, String username, String password) throws Exception {
        return serverManagement.getServerThreadsInformation(jmxUrl, username, password);
    }

    public void deploy(String fileName, String serverName) throws Exception {
        serverManagement.deploy(fileName, serverName);
    }

    public void undeploy(String fileName, String serverName) throws Exception {
        serverManagement.undeploy(fileName, serverName);
    }

    public boolean remove(String fileName, String serverName) throws Exception {
        return serverManagement.remove(fileName, serverName);
    }

    public boolean developmentMode(String serviceName, String serverName) throws Exception {
        return serverManagement.developmentMode(serviceName, serverName);
    }

    public Object getAttribute(ObjectName on, String attribute, String serverName) throws ManagementException {
        return domainManagement.getAttribute(on, attribute, serverName);
    }

    public J2EEMBeanAttributeInfo[] getAttributes(ObjectName objectName, String serverName) throws ManagementException {
        return domainManagement.getAttributes(objectName, serverName);
    }

    public int getIntegerAttribute(ObjectName objectName, String attrName) throws ManagementException {
        return domainManagement.getIntegerAttribute(objectName, attrName);
    }

    public String getKeyValue(String objectName, String keyName) throws ManagementException {
        return domainManagement.getKeyValue(objectName, keyName);
    }

    public String[] getKeyValues(String[] objectNames, String keyName) throws ManagementException {
        return domainManagement.getKeyValues(objectNames, keyName);
    }

    public List getListMbean(ObjectName on, String serverName) throws ManagementException {
        return domainManagement.getListMbean(on, serverName);
    }

    public String getStringAttribute(ObjectName objectName, String attrName) throws ManagementException {
        return domainManagement.getStringAttribute(objectName, attrName);
    }

    public Object invoke(ObjectName on, String operation, Object[] param, String[] signature, String serverName) throws ManagementException {
        return domainManagement.invoke(on, operation, param, signature, serverName);
    }

    public boolean isRegistered(ObjectName on, String serverName) throws ManagementException {
        return domainManagement.isRegistered(on, serverName);
    }

    public MBeanServerConnection getServerConnection(String serverName) throws ManagementException {
        return domainManagement.getServerConnection(serverName);
    }

    public MBeanServerConnection getServerConnection() throws ManagementException {
        return domainManagement.getServerConnection();
    }

    public void setAttribute(ObjectName on, String attribute, Object value, String serverName) throws ManagementException {
        domainManagement.setAttribute(on, attribute, value, serverName);
    }

    public void setAttribute(ObjectName on, String attribute, Object value) throws ManagementException {
        domainManagement.setAttribute(on, attribute, value);
    }

    public List<?> getRealmItems(String realmType, String securityRealmUsed, String domainName, String serverName) throws ManagementException {
        return domainManagement.getRealmItems(realmType, securityRealmUsed, domainName, serverName);
    }

    public List<?> getRealmItems(String realmType, String securityRealmUsed) throws ManagementException {
        return domainManagement.getRealmItems(realmType, securityRealmUsed);
    }
}

