/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.OpCodes;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Clazz {
    static final byte[] SkipTable;
    String className;
    Object[] pool;
    int[] intPool;
    Map<String, Map<String, String>> imports = new HashMap<String, Map<String, String>>();
    String path;
    int minor = 0;
    int major = 0;
    String sourceFile;
    Set<String> xref;
    Set<Integer> classes;
    Set<Integer> descriptors;
    int forName = 0;
    int class$ = 0;
    String[] interfaces;
    String zuper;

    static {
        byte[] byArray = new byte[13];
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = 4;
        byArray[4] = 4;
        byArray[5] = 8;
        byArray[6] = 8;
        byArray[7] = -1;
        byArray[8] = 2;
        byArray[9] = 4;
        byArray[10] = 4;
        byArray[11] = 4;
        byArray[12] = 4;
        SkipTable = byArray;
    }

    public Clazz(String path) {
        this.path = path;
    }

    public Clazz(String path, InputStream in) throws IOException {
        this.path = path;
        DataInputStream din = new DataInputStream(in);
        this.parseClassFile(din);
        din.close();
    }

    Set<String> parseClassFile(DataInputStream in) throws IOException {
        int descriptor_index;
        this.xref = new HashSet<String>();
        this.classes = new HashSet<Integer>();
        this.descriptors = new HashSet<Integer>();
        boolean crawl = false;
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new IOException("Not a valid class file (no CAFEBABE header)");
        }
        this.minor = in.readUnsignedShort();
        this.major = in.readUnsignedShort();
        int count = in.readUnsignedShort();
        this.pool = new Object[count];
        this.intPool = new int[count];
        int poolIndex = 1;
        block10: while (poolIndex < count) {
            byte tag = in.readByte();
            switch (tag) {
                case 0: {
                    break block10;
                }
                case 1: {
                    this.constantUtf8(in, poolIndex);
                    break;
                }
                case 5: {
                    this.constantLong(in, poolIndex);
                    ++poolIndex;
                    break;
                }
                case 6: {
                    this.constantDouble(in, poolIndex);
                    ++poolIndex;
                    break;
                }
                case 7: {
                    this.constantClass(in, poolIndex);
                    break;
                }
                case 8: {
                    this.constantString(in, poolIndex);
                    break;
                }
                case 10: {
                    this.methodRef(in, poolIndex);
                    break;
                }
                case 12: {
                    this.nameAndType(in, poolIndex, tag);
                    break;
                }
                default: {
                    if (tag == 2) {
                        throw new IOException("Invalid tag " + tag);
                    }
                    in.skipBytes(SkipTable[tag]);
                }
            }
            ++poolIndex;
        }
        this.pool(this.pool, this.intPool);
        in.readUnsignedShort();
        int this_class = in.readUnsignedShort();
        int super_class = in.readUnsignedShort();
        this.zuper = (String)this.pool[this.intPool[super_class]];
        if (this.zuper != null) {
            this.addReference(this.zuper);
        }
        this.className = (String)this.pool[this.intPool[this_class]];
        int interfacesCount = in.readUnsignedShort();
        if (interfacesCount > 0) {
            this.interfaces = new String[interfacesCount];
            int i = 0;
            while (i < interfacesCount) {
                this.interfaces[i] = (String)this.pool[this.intPool[in.readUnsignedShort()]];
                ++i;
            }
        }
        int fieldsCount = in.readUnsignedShort();
        int i = 0;
        while (i < fieldsCount) {
            in.readUnsignedShort();
            int name_index = in.readUnsignedShort();
            descriptor_index = in.readUnsignedShort();
            String name = this.pool[name_index].toString();
            if (name.startsWith("class$")) {
                crawl = true;
            }
            this.descriptors.add(new Integer(descriptor_index));
            this.doAttributes(in, false);
            ++i;
        }
        if (crawl) {
            this.forName = this.findMethod("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
            this.class$ = this.findMethod(this.className, "class$", "(Ljava/lang/String;)Ljava/lang/Class;");
        }
        int methodCount = in.readUnsignedShort();
        int i2 = 0;
        while (i2 < methodCount) {
            in.readUnsignedShort();
            in.readUnsignedShort();
            descriptor_index = in.readUnsignedShort();
            this.descriptors.add(new Integer(descriptor_index));
            this.doAttributes(in, crawl);
            ++i2;
        }
        this.doAttributes(in, false);
        Iterator<Integer> e = this.classes.iterator();
        while (e.hasNext()) {
            short class_index = e.next().shortValue();
            this.doClassReference((String)this.pool[class_index]);
        }
        for (Integer index : this.descriptors) {
            String prototype = (String)this.pool[index];
            if (prototype != null) {
                this.parseDescriptor(prototype);
                continue;
            }
            System.err.println("Unrecognized descriptor: " + index);
        }
        Set<String> xref = this.xref;
        this.reset();
        return xref;
    }

    protected void pool(Object[] pool, int[] intPool) {
    }

    protected void nameAndType(DataInputStream in, int poolIndex, byte tag) throws IOException {
        int name_index = in.readUnsignedShort();
        int descriptor_index = in.readUnsignedShort();
        this.descriptors.add(new Integer(descriptor_index));
        this.pool[poolIndex] = new Assoc(tag, name_index, descriptor_index);
    }

    private void methodRef(DataInputStream in, int poolIndex) throws IOException {
        int class_index = in.readUnsignedShort();
        int name_and_type_index = in.readUnsignedShort();
        this.pool[poolIndex] = new Assoc(10, class_index, name_and_type_index);
    }

    private void constantString(DataInputStream in, int poolIndex) throws IOException {
        int string_index;
        this.intPool[poolIndex] = string_index = in.readUnsignedShort();
    }

    protected void constantClass(DataInputStream in, int poolIndex) throws IOException {
        int class_index = in.readUnsignedShort();
        this.classes.add(new Integer(class_index));
        this.intPool[poolIndex] = class_index;
    }

    protected void constantDouble(DataInputStream in, int poolIndex) throws IOException {
        in.skipBytes(8);
    }

    protected void constantLong(DataInputStream in, int poolIndex) throws IOException {
        in.skipBytes(8);
    }

    protected void constantUtf8(DataInputStream in, int poolIndex) throws IOException {
        String name = in.readUTF();
        this.xref.add(name);
        this.pool[poolIndex] = name;
    }

    private int findMethod(String clazz, String methodname, String descriptor) {
        int i = 1;
        while (i < this.pool.length) {
            if (this.pool[i] instanceof Assoc) {
                int class_index;
                int class_name_index;
                Assoc methodref = (Assoc)this.pool[i];
                if (methodref.tag == 10 && clazz.equals(this.pool[class_name_index = this.intPool[class_index = methodref.a]])) {
                    int name_and_type_index = methodref.b;
                    Assoc name_and_type = (Assoc)this.pool[name_and_type_index];
                    if (name_and_type.tag == 12) {
                        int name_index = name_and_type.a;
                        int type_index = name_and_type.b;
                        if (methodname.equals(this.pool[name_index]) && descriptor.equals(this.pool[type_index])) {
                            return i;
                        }
                    }
                }
            }
            ++i;
        }
        return -1;
    }

    private void doClassReference(String next) {
        if (next != null) {
            String normalized = Clazz.normalize(next);
            if (normalized != null) {
                String pack = Clazz.getPackage(normalized);
                this.packageReference(pack);
            }
        } else {
            throw new IllegalArgumentException("Invalid class, parent=");
        }
    }

    private void doAttributes(DataInputStream in, boolean crawl) throws IOException {
        int attributesCount = in.readUnsignedShort();
        int j = 0;
        while (j < attributesCount) {
            this.doAttribute(in, crawl);
            ++j;
        }
    }

    private void doAttribute(DataInputStream in, boolean crawl) throws IOException {
        int attribute_name_index = in.readUnsignedShort();
        String attributeName = (String)this.pool[attribute_name_index];
        if (attribute_name_index == 560) {
            System.out.println("Index " + attribute_name_index + ":" + attributeName);
        }
        long attribute_length = in.readInt();
        attribute_length &= 0xFFFFFFFFFFFFFFFFL;
        if ("RuntimeVisibleAnnotations".equals(attributeName)) {
            this.doAnnotations(in);
        } else if ("RuntimeVisibleParameterAnnotations".equals(attributeName)) {
            this.doParameterAnnotations(in);
        } else if ("SourceFile".equals(attributeName)) {
            this.doSourceFile(in);
        } else if ("Code".equals(attributeName) && crawl) {
            this.doCode(in);
        } else {
            if (attribute_length > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Attribute > 2Gb");
            }
            in.skipBytes((int)attribute_length);
        }
    }

    private void doCode(DataInputStream in) throws IOException {
        in.readUnsignedShort();
        in.readUnsignedShort();
        int code_length = in.readInt();
        byte[] code = new byte[code_length];
        in.readFully(code);
        this.crawl(code);
        int exception_table_length = in.readUnsignedShort();
        in.skipBytes(exception_table_length * 8);
        this.doAttributes(in, false);
    }

    protected void crawl(byte[] code) {
        ByteBuffer bb = ByteBuffer.wrap(code);
        bb.order(ByteOrder.BIG_ENDIAN);
        int lastReference = -1;
        block7: while (bb.remaining() > 0) {
            int instruction = 0xFF & bb.get();
            switch (instruction) {
                case 18: {
                    lastReference = 0xFF & bb.get();
                    break;
                }
                case 19: {
                    lastReference = 0xFFFF & bb.getShort();
                    break;
                }
                case 184: {
                    int methodref = 0xFFFF & bb.getShort();
                    if (methodref != this.forName && methodref != this.class$ || lastReference == -1 || !(this.pool[this.intPool[lastReference]] instanceof String)) continue block7;
                    String clazz = (String)this.pool[this.intPool[lastReference]];
                    this.doClassReference(clazz.replace('.', '/'));
                    break;
                }
                case 170: {
                    while ((bb.position() & 3) != 0) {
                        bb.get();
                    }
                    bb.getInt();
                    int low = bb.getInt();
                    int high = bb.getInt();
                    bb.position(bb.position() + (high - low + 1) * 4);
                    lastReference = -1;
                    break;
                }
                case 171: {
                    while ((bb.position() & 3) != 0) {
                        bb.get();
                    }
                    bb.getInt();
                    int npairs = bb.getInt();
                    bb.position(bb.position() + npairs * 8);
                    lastReference = -1;
                    break;
                }
                default: {
                    lastReference = -1;
                    bb.position(bb.position() + OpCodes.OFFSETS[instruction]);
                }
            }
        }
    }

    private void doSourceFile(DataInputStream in) throws IOException {
        int sourcefile_index = in.readUnsignedShort();
        this.sourceFile = this.pool[sourcefile_index].toString();
    }

    private void doParameterAnnotations(DataInputStream in) throws IOException {
        int num_parameters = in.readUnsignedByte();
        int p = 0;
        while (p < num_parameters) {
            int num_annotations = in.readUnsignedShort();
            int a = 0;
            while (a < num_annotations) {
                this.doAnnotation(in);
                ++a;
            }
            ++p;
        }
    }

    private void doAnnotations(DataInputStream in) throws IOException {
        int num_annotations = in.readUnsignedShort();
        int a = 0;
        while (a < num_annotations) {
            this.doAnnotation(in);
            ++a;
        }
    }

    private void doAnnotation(DataInputStream in) throws IOException {
        int type_index = in.readUnsignedShort();
        this.descriptors.add(new Integer(type_index));
        int num_element_value_pairs = in.readUnsignedShort();
        int v = 0;
        while (v < num_element_value_pairs) {
            in.readUnsignedShort();
            this.doElementValue(in);
            ++v;
        }
    }

    private void doElementValue(DataInputStream in) throws IOException {
        int tag = in.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                in.readUnsignedShort();
                break;
            }
            case 101: {
                int type_name_index = in.readUnsignedShort();
                this.descriptors.add(new Integer(type_name_index));
                in.readUnsignedShort();
                break;
            }
            case 99: {
                int class_info_index = in.readUnsignedShort();
                this.descriptors.add(new Integer(class_info_index));
                break;
            }
            case 64: {
                this.doAnnotation(in);
                break;
            }
            case 91: {
                int num_values = in.readUnsignedShort();
                int i = 0;
                while (i < num_values) {
                    this.doElementValue(in);
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for Annotation ElementValue tag " + tag);
            }
        }
    }

    void packageReference(String pack) {
        if (pack.indexOf(60) >= 0) {
            System.out.println("Oops: " + pack);
        }
        if (!this.imports.containsKey(pack)) {
            this.imports.put(pack, new LinkedHashMap());
        }
    }

    void parseDescriptor(String prototype) {
        this.addReference(prototype);
        StringTokenizer st = new StringTokenizer(prototype, "(;)", true);
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals("(")) continue;
            String token = st.nextToken();
            while (!token.equals(")")) {
                this.addReference(token);
                token = st.nextToken();
            }
            token = st.nextToken();
            this.addReference(token);
        }
    }

    private void addReference(String token) {
        while (token.startsWith("[")) {
            token = token.substring(1);
        }
        if (token.startsWith("L")) {
            String clazz = Clazz.normalize(token.substring(1));
            if (clazz.startsWith("java/")) {
                return;
            }
            String pack = Clazz.getPackage(clazz);
            this.packageReference(pack);
        }
    }

    static String normalize(String s) {
        if (s.startsWith("[L")) {
            return Clazz.normalize(s.substring(2));
        }
        if (s.startsWith("[")) {
            if (s.length() == 2) {
                return null;
            }
            return Clazz.normalize(s.substring(1));
        }
        if (s.endsWith(";")) {
            return Clazz.normalize(s.substring(0, s.length() - 1));
        }
        return String.valueOf(s) + ".class";
    }

    public static String getPackage(String clazz) {
        int n = clazz.lastIndexOf(47);
        if (n < 0) {
            return ".";
        }
        return clazz.substring(0, n).replace('/', '.');
    }

    public Map<String, Map<String, String>> getReferred() {
        return this.imports;
    }

    String getClassName() {
        return this.className;
    }

    public String getPath() {
        return this.path;
    }

    public Set<String> xref(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        Set<String> set = this.parseClassFile(din);
        din.close();
        return set;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void reset() {
        this.pool = null;
        this.intPool = null;
        this.xref = null;
        this.classes = null;
        this.descriptors = null;
    }

    public boolean is(QUERY query, Instruction instr, Map<String, Clazz> classspace) {
        switch (query) {
            case ANY: {
                return true;
            }
            case NAMED: {
                if (instr.matches(this.getClassName())) {
                    return !instr.isNegated();
                }
                return false;
            }
            case VERSION: {
                String v = String.valueOf(this.major) + "/" + this.minor;
                if (instr.matches(v)) {
                    return !instr.isNegated();
                }
                return false;
            }
            case IMPLEMENTS: {
                int i = 0;
                while (this.interfaces != null && i < this.interfaces.length) {
                    if (instr.matches(this.interfaces[i])) {
                        return !instr.isNegated();
                    }
                    ++i;
                }
                break;
            }
            case EXTENDS: {
                if (this.zuper == null) {
                    return false;
                }
                if (!instr.matches(this.zuper)) break;
                return !instr.isNegated();
            }
            case IMPORTS: {
                for (String imp : this.imports.keySet()) {
                    if (!instr.matches(imp.replace('.', '/'))) continue;
                    return !instr.isNegated();
                }
                break;
            }
        }
        if (this.zuper == null || classspace == null) {
            return false;
        }
        Clazz clazz = classspace.get(this.zuper);
        if (clazz == null) {
            return false;
        }
        return clazz.is(query, instr, classspace);
    }

    public String toString() {
        return this.getFQN();
    }

    public String getFQN() {
        return this.getClassName().replace('/', '.');
    }

    protected static class Assoc {
        byte tag;
        int a;
        int b;

        Assoc(byte tag, int a, int b) {
            this.tag = tag;
            this.a = a;
            this.b = b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QUERY {
        IMPLEMENTS,
        EXTENDS,
        IMPORTS,
        NAMED,
        ANY,
        VERSION;

    }
}

