/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Instruction {
    Pattern pattern;
    String instruction;
    boolean negated;

    public Instruction(String instruction, boolean negated) {
        this.instruction = instruction;
        this.negated = negated;
    }

    public boolean matches(String value) {
        return this.getMatcher(value).matches();
    }

    public boolean isNegated() {
        return this.negated;
    }

    public String getPattern() {
        return this.instruction;
    }

    public static Instruction getPattern(String string) {
        boolean negated = false;
        if (string.startsWith("!")) {
            negated = true;
            string = string.substring(1);
        }
        StringBuffer sb = new StringBuffer();
        int c = 0;
        while (c < string.length()) {
            switch (string.charAt(c)) {
                case '.': {
                    sb.append("\\.");
                    break;
                }
                case '*': {
                    sb.append(".*");
                    break;
                }
                case '?': {
                    sb.append(".?");
                    break;
                }
                default: {
                    sb.append(string.charAt(c));
                }
            }
            ++c;
        }
        string = sb.toString();
        if (string.endsWith("\\..*")) {
            sb.append("|");
            sb.append(string.substring(0, string.length() - 4));
        }
        return new Instruction(sb.toString(), negated);
    }

    public String toString() {
        return this.getPattern();
    }

    public Matcher getMatcher(String value) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.instruction);
        }
        return this.pattern.matcher(value);
    }
}

