/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.jacorb.notification.servant.AbstractProxyConsumer;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.servant.IProxyConsumer;
import org.jacorb.notification.servant.MessageSupplierDelegate;
import org.jacorb.notification.servant.ProxyPullConsumerImplMBean;
import org.jacorb.notification.servant.PullMessagesOperation;
import org.jacorb.notification.servant.PullMessagesUtility;
import org.omg.CORBA.Any;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosEventComm.PullSupplier;
import org.omg.CosNotifyChannelAdmin.ProxyConsumerHelper;
import org.omg.CosNotifyChannelAdmin.ProxyPullConsumerOperations;
import org.omg.CosNotifyChannelAdmin.ProxyPullConsumerPOATie;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class ProxyPullConsumerImpl
extends AbstractProxyConsumer
implements ProxyPullConsumerOperations,
MessageSupplier,
MessageSupplierDelegate,
ProxyPullConsumerImplMBean {
    private PullSupplier pullSupplier_;
    private long pollInterval_;
    private final PullMessagesOperation pullMessagesOperation_;
    private final PullMessagesUtility pollTaskUtility_;

    public ProxyPullConsumerImpl(IAdmin iAdmin, ORB oRB, POA pOA, Configuration configuration, TaskProcessor taskProcessor, MessageFactory messageFactory, OfferManager offerManager, SubscriptionManager subscriptionManager) {
        super(iAdmin, oRB, pOA, configuration, taskProcessor, messageFactory, null, offerManager, subscriptionManager);
        this.pollInterval_ = configuration.getAttributeAsLong("jacorb.notification.supplier.poll_intervall", 1000L);
        this.pullMessagesOperation_ = new PullMessagesOperation(this);
        this.pollTaskUtility_ = new PullMessagesUtility(taskProcessor, this);
    }

    public ProxyType MyType() {
        return ProxyType.PULL_ANY;
    }

    public void disconnect_pull_consumer() {
        this.destroy();
    }

    protected void disconnectClient() {
        this.stopTask();
        this.pullSupplier_.disconnect_pull_supplier();
        this.pullSupplier_ = null;
    }

    protected void connectionSuspended() {
        this.stopTask();
    }

    protected void connectionResumed() {
        this.startTask();
    }

    public void runPullMessage() throws Disconnected {
        this.pullMessagesOperation_.runPull();
    }

    public void connect_any_pull_supplier(PullSupplier pullSupplier) throws AlreadyConnected {
        this.checkIsNotConnected();
        this.pullSupplier_ = pullSupplier;
        this.connectClient(pullSupplier);
        this.startTask();
    }

    private synchronized void startTask() {
        this.pollTaskUtility_.startTask(this.pollInterval_);
    }

    private synchronized void stopTask() {
        this.pollTaskUtility_.stopTask();
    }

    public synchronized Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = new ProxyPullConsumerPOATie(this);
        }
        return this.thisServant_;
    }

    public Object activate() {
        return ProxyConsumerHelper.narrow(this.getServant()._this_object(this.getORB()));
    }

    public long getPollInterval() {
        return this.pollInterval_;
    }

    public long getPullTimer() {
        return this.pullMessagesOperation_.getTimeSpentInPull();
    }

    public int getPullCounter() {
        return this.pullMessagesOperation_.getPullCounter();
    }

    public int getSuccessfulPullCounter() {
        return this.pullMessagesOperation_.getSuccessfulPullCounter();
    }

    public MessageSupplierDelegate.PullResult pullMessages() throws Disconnected {
        BooleanHolder booleanHolder = new BooleanHolder();
        Any any = this.pullSupplier_.try_pull(booleanHolder);
        return new MessageSupplierDelegate.PullResult(any, booleanHolder.value);
    }

    public void queueMessages(MessageSupplierDelegate.PullResult pullResult) {
        Message message = this.getMessageFactory().newMessage((Any)pullResult.data_, (IProxyConsumer)this);
        this.checkMessageProperties(message);
        this.processMessage(message);
    }
}

