/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InterceptSendToEndpoint
implements Endpoint {
    private static final transient Log LOG = LogFactory.getLog(InterceptSendToEndpoint.class);
    private final Endpoint delegate;
    private Producer producer;
    private Processor detour;
    private boolean skip;

    public InterceptSendToEndpoint(Endpoint destination, boolean skip) {
        this.delegate = destination;
        this.skip = skip;
    }

    public void setDetour(Processor detour) {
        this.detour = detour;
    }

    public Endpoint getDelegate() {
        return this.delegate;
    }

    public String getEndpointUri() {
        return this.delegate.getEndpointUri();
    }

    public String getEndpointKey() {
        return this.delegate.getEndpointKey();
    }

    public Exchange createExchange() {
        return this.delegate.createExchange();
    }

    public Exchange createExchange(ExchangePattern pattern) {
        return this.delegate.createExchange(pattern);
    }

    public Exchange createExchange(Exchange exchange) {
        return this.delegate.createExchange(exchange);
    }

    public CamelContext getCamelContext() {
        return this.delegate.getCamelContext();
    }

    public Producer createProducer() throws Exception {
        this.producer = this.delegate.createProducer();
        return new Producer(){

            public Endpoint getEndpoint() {
                return InterceptSendToEndpoint.this.producer.getEndpoint();
            }

            public Exchange createExchange() {
                return InterceptSendToEndpoint.this.producer.createExchange();
            }

            public Exchange createExchange(ExchangePattern pattern) {
                return InterceptSendToEndpoint.this.producer.createExchange(pattern);
            }

            public Exchange createExchange(Exchange exchange) {
                return InterceptSendToEndpoint.this.producer.createExchange(exchange);
            }

            public void process(Exchange exchange) throws Exception {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Sending to endpoint: " + InterceptSendToEndpoint.this.getEndpointUri() + " is intercepted and detoured to: " + InterceptSendToEndpoint.this.detour + " for exchange: " + exchange));
                }
                exchange.getIn().setHeader("CamelInterceptedEndpoint", InterceptSendToEndpoint.this.delegate.getEndpointUri());
                InterceptSendToEndpoint.this.detour.process(exchange);
                if (exchange.hasOut()) {
                    exchange.setIn(exchange.getOut());
                    exchange.setOut(null);
                }
                if (!InterceptSendToEndpoint.this.skip) {
                    InterceptSendToEndpoint.this.producer.process(exchange);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Stop() means skip sending exchange to original intended destination: " + InterceptSendToEndpoint.this.getEndpointUri() + " for exchange: " + exchange));
                }
            }

            public boolean isSingleton() {
                return InterceptSendToEndpoint.this.producer.isSingleton();
            }

            public void start() throws Exception {
                ServiceHelper.startService(InterceptSendToEndpoint.this.detour);
            }

            public void stop() throws Exception {
                ServiceHelper.stopService(InterceptSendToEndpoint.this.detour);
            }
        };
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return this.delegate.createConsumer(processor);
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        return this.delegate.createPollingConsumer();
    }

    public void configureProperties(Map options) {
        this.delegate.configureProperties(options);
    }

    public void setCamelContext(CamelContext context) {
        this.delegate.setCamelContext(context);
    }

    public boolean isLenientProperties() {
        return this.delegate.isLenientProperties();
    }

    public boolean isSingleton() {
        return this.delegate.isSingleton();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

