/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.RouteContext;

@XmlRootElement(name="expression")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExpressionSubElementDefinition {
    @XmlElementRef
    private ExpressionDefinition expressionType;
    @XmlTransient
    private Expression expression;
    @XmlTransient
    private Predicate predicate;

    public ExpressionSubElementDefinition() {
    }

    public ExpressionSubElementDefinition(Expression expression) {
        this.expression = expression;
    }

    public ExpressionSubElementDefinition(Predicate predicate) {
        this.predicate = predicate;
    }

    public ExpressionDefinition getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(ExpressionDefinition expressionType) {
        this.expressionType = expressionType;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public Expression createExpression(RouteContext routeContext) {
        ExpressionDefinition expressionType = this.getExpressionType();
        if (expressionType != null && this.expression == null) {
            this.expression = expressionType.createExpression(routeContext);
        }
        return this.expression;
    }

    public Predicate createPredicate(RouteContext routeContext) {
        ExpressionDefinition expressionType = this.getExpressionType();
        if (expressionType != null && this.getPredicate() == null) {
            this.setPredicate(expressionType.createPredicate(routeContext));
        }
        return this.getPredicate();
    }
}

