/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.processor.Traceable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilterProcessor
extends DelegateProcessor
implements Traceable {
    private static final Log LOG = LogFactory.getLog(FilterProcessor.class);
    private final Predicate predicate;

    public FilterProcessor(Predicate predicate, Processor processor) {
        super(processor);
        this.predicate = predicate;
    }

    public void process(Exchange exchange) throws Exception {
        if (this.predicate.matches(exchange)) {
            super.process(exchange);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Marking exchange as filtered: " + exchange));
            }
            exchange.setProperty("CamelFiltered", Boolean.TRUE);
        }
    }

    public String toString() {
        return "Filter[if: " + this.predicate + " do: " + this.getProcessor() + "]";
    }

    public String getTraceLabel() {
        return "Filter[if: " + this.predicate + "]";
    }

    public Predicate getPredicate() {
        return this.predicate;
    }
}

