/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public class RecipientList
extends ServiceSupport
implements Processor {
    private ProducerCache producerCache;
    private Expression expression;

    public RecipientList() {
    }

    public RecipientList(Expression expression) {
        ObjectHelper.notNull(expression, "expression");
        this.expression = expression;
    }

    public String toString() {
        return "RecipientList[" + (this.expression != null ? this.expression : "") + "]";
    }

    public void process(Exchange exchange) throws Exception {
        Object receipientList = this.expression.evaluate(exchange, Object.class);
        this.sendToRecipientList(exchange, receipientList);
    }

    public void sendToRecipientList(Exchange exchange, Object receipientList) throws Exception {
        Iterator iter = ObjectHelper.createIterator(receipientList);
        ArrayList<Processor> processors = new ArrayList<Processor>();
        while (iter.hasNext()) {
            Object recipient = iter.next();
            Endpoint endpoint = this.resolveEndpoint(exchange, recipient);
            Producer producer = this.getProducerCache(exchange).getProducer(endpoint);
            processors.add(producer);
        }
        MulticastProcessor mp = new MulticastProcessor(processors, new UseLatestAggregationStrategy());
        mp.process(exchange);
    }

    protected ProducerCache getProducerCache(Exchange exchange) throws Exception {
        if (this.producerCache == null) {
            this.producerCache = new ProducerCache(exchange.getContext().getProducerServicePool());
            this.producerCache.start();
        }
        return this.producerCache;
    }

    protected Endpoint resolveEndpoint(Exchange exchange, Object recipient) {
        if (recipient instanceof String) {
            recipient = ((String)recipient).trim();
        }
        return ExchangeHelper.resolveEndpoint(exchange, recipient);
    }

    protected void doStart() throws Exception {
        if (this.producerCache != null) {
            this.producerCache.start();
        }
    }

    protected void doStop() throws Exception {
        if (this.producerCache != null) {
            this.producerCache.stop();
        }
    }
}

