/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.util.Comparator;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.file.remote.RemoteFile;
import org.apache.camel.language.simple.FileLanguage;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultRemoteFileSorter {
    private DefaultRemoteFileSorter() {
    }

    public static Comparator<RemoteFile> sortByName(final boolean reverse) {
        return new Comparator<RemoteFile>(){

            @Override
            public int compare(RemoteFile o1, RemoteFile o2) {
                int answer = o1.getFileName().compareTo(o2.getFileName());
                return reverse ? -1 * answer : answer;
            }
        };
    }

    public static Comparator<RemoteFile> sortByPathName(final boolean reverse) {
        return new Comparator<RemoteFile>(){

            @Override
            public int compare(RemoteFile o1, RemoteFile o2) {
                int answer = o1.getParent().compareTo(o2.getParent());
                return reverse ? -1 * answer : answer;
            }
        };
    }

    public static Comparator<RemoteFile> sortByLastModified(final boolean reverse) {
        return new Comparator<RemoteFile>(){

            @Override
            public int compare(RemoteFile o1, RemoteFile o2) {
                long delta = o1.getLastModified() - o2.getLastModified();
                if (delta == 0L) {
                    return 0;
                }
                int answer = delta > 0L ? 1 : -1;
                return reverse ? -1 * answer : answer;
            }
        };
    }

    public static Comparator<RemoteFile> sortBySize(final boolean reverse) {
        return new Comparator<RemoteFile>(){

            @Override
            public int compare(RemoteFile o1, RemoteFile o2) {
                long delta = o1.getFileLength() - o2.getFileLength();
                if (delta == 0L) {
                    return 0;
                }
                int answer = delta > 0L ? 1 : -1;
                return reverse ? -1 * answer : answer;
            }
        };
    }

    public static Comparator<Exchange> sortByFileLanguage(String expression, boolean reverse) {
        return DefaultRemoteFileSorter.sortByFileLanguage(expression, reverse, false, null);
    }

    public static Comparator<Exchange> sortByFileLanguage(String expression, boolean reverse, boolean ignoreCase) {
        return DefaultRemoteFileSorter.sortByFileLanguage(expression, reverse, ignoreCase, null);
    }

    public static Comparator<Exchange> sortByFileLanguage(final String expression, final boolean reverse, final boolean ignoreCase, final Comparator<Exchange> nested) {
        return new Comparator<Exchange>(){

            @Override
            public int compare(Exchange o1, Exchange o2) {
                Object result2;
                Expression exp = FileLanguage.file((String)expression);
                Object result1 = exp.evaluate(o1, Object.class);
                int answer = ObjectHelper.compare((Object)result1, (Object)(result2 = exp.evaluate(o2, Object.class)), (boolean)ignoreCase);
                if (answer == 0 && nested != null) {
                    answer = nested.compare(o1, o2);
                }
                return reverse ? -1 * answer : answer;
            }

            public String toString() {
                return expression + (nested != null ? ";" + nested.toString() : "");
            }
        };
    }
}

