/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.server;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.common.Daemon;
import fr.dyade.aaa.jndi2.server.TcpRequestContext;
import fr.dyade.aaa.jndi2.server.TcpRequestNot;
import fr.dyade.aaa.jndi2.server.Trace;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.objectweb.util.monolog.api.BasicLevel;

public class TcpServer {
    private volatile ServerSocket listen;
    private Monitor[] monitors;
    private AgentId serverId;

    public TcpServer(ServerSocket listen, int poolSize, int timeout, AgentId serverId) {
        this.listen = listen;
        this.monitors = new Monitor[poolSize];
        this.serverId = serverId;
        for (int i = 0; i < this.monitors.length; ++i) {
            this.monitors[i] = new Monitor("JndiServer.Monitor#" + i, timeout, this);
            this.monitors[i].setDaemon(true);
            this.monitors[i].setThreadGroup(AgentServer.getThreadGroup());
        }
    }

    public final void start() {
        for (int i = 0; i < this.monitors.length; ++i) {
            this.monitors[i].start();
        }
    }

    public final void stop() {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)"TcpServer.stop()");
        }
        try {
            this.listen.close();
            this.listen = null;
        }
        catch (Exception exc) {
            // empty catch block
        }
        for (int i = 0; i < this.monitors.length; ++i) {
            this.monitors[i].stop();
        }
    }

    public final ServerSocket getListen() {
        return this.listen;
    }

    public final AgentId getServerId() {
        return this.serverId;
    }

    public static class Monitor
    extends Daemon {
        private int timeout;
        private TcpServer tcpServer;

        protected Monitor(String name, int timeout, TcpServer tcpServer) {
            super(name);
            this.timeout = timeout;
            this.tcpServer = tcpServer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void run() {
            try {
                while (this.running) {
                    Socket socket;
                    this.canStop = true;
                    try {
                        ServerSocket listen = this.tcpServer.getListen();
                        if (listen == null) return;
                        socket = listen.accept();
                        socket.setTcpNoDelay(true);
                        socket.setSoTimeout(this.timeout);
                        socket.setSoLinger(true, 1000);
                        this.canStop = false;
                    }
                    catch (IOException exc) {
                        this.canStop = false;
                        Thread.interrupted();
                        if (!this.running) return;
                        Trace.logger.log(BasicLevel.DEBUG, (Object)(this.getName() + ", error during accept"), (Throwable)exc);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        continue;
                    }
                    finally {
                        this.canStop = false;
                        continue;
                    }
                    if (!this.running) {
                        return;
                    }
                    if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                        Trace.logger.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection from " + socket.getInetAddress() + ':' + socket.getPort()));
                    }
                    try {
                        TcpRequestContext ctx = new TcpRequestContext(socket);
                        Channel.sendTo(this.tcpServer.getServerId(), new TcpRequestNot(ctx));
                    }
                    catch (Exception exc) {
                        Trace.logger.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during send"), (Throwable)exc);
                        if (socket == null) continue;
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return;
            }
            finally {
                this.finish();
            }
        }

        protected void close() {
        }

        protected void shutdown() {
            this.close();
        }
    }
}

