/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.ManagedConnectionImpl;
import org.objectweb.joram.client.connector.OutboundSession;
import org.objectweb.util.monolog.api.BasicLevel;

public class OutboundConnection
implements Connection {
    ManagedConnectionImpl managedCx;
    XAConnection xac;
    boolean valid = true;
    Vector sessions;

    OutboundConnection(ManagedConnectionImpl managedCx, XAConnection xac) {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("OutboundConnection(" + managedCx + ", " + xac + ")"));
        }
        this.managedCx = managedCx;
        this.xac = xac;
        this.sessions = new Vector();
    }

    public void setClientID(String clientID) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " setClientID(" + clientID + ")"));
        }
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        throw new IllegalStateException("Forbidden call on a component's connection.");
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " setExceptionListener(" + listener + ")"));
        }
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        throw new IllegalStateException("Forbidden call on a component's connection.");
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        Session sess;
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createSession(" + transacted + ", " + acknowledgeMode + ")"));
        }
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createSession sess = " + this.managedCx.session));
        }
        if ((sess = this.managedCx.session) == null) {
            sess = this.xac.createSession(false, acknowledgeMode);
        }
        return new OutboundSession(sess, this, transacted);
    }

    public String getClientID() throws JMSException {
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        throw new IllegalStateException("Forbidden call on a component's connection.");
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        return this.xac.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        throw new IllegalStateException("Forbidden call on a component's connection.");
    }

    public void start() throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " start()"));
        }
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        this.xac.start();
        for (int i = 0; i < this.sessions.size(); ++i) {
            OutboundSession session = (OutboundSession)this.sessions.get(i);
            session.start();
            if (!AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) continue;
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " start session = " + session));
        }
    }

    public void stop() throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " stop()"));
        }
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        throw new IllegalStateException("Forbidden call on a component's connection.");
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        throw new IllegalStateException("Forbidden call on a component's connection.");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        throw new IllegalStateException("Forbidden call on a component's connection.");
    }

    public synchronized void close() throws JMSException {
        this.valid = false;
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " close()"));
        }
        for (int i = 0; i < this.sessions.size(); ++i) {
            OutboundSession session = (OutboundSession)this.sessions.get(i);
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " close() session = " + session));
            }
            session.close();
        }
        this.managedCx.closeHandle(this);
    }

    public boolean cnxEquals(Object obj) {
        return obj instanceof Connection && this.xac.equals(obj);
    }

    public void cleanup() {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " cleanup()"));
        }
        org.objectweb.joram.client.jms.Connection cnx = (org.objectweb.joram.client.jms.Connection)this.xac;
        cnx.cleanup();
    }

    public String toString() {
        return "OutboundConnection[" + this.xac.toString() + "]";
    }
}

