/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingOperationInfo;

public class CxfConsumer
extends DefaultConsumer {
    private static final Log LOG = LogFactory.getLog(CxfConsumer.class);
    private Server server;

    public CxfConsumer(CxfEndpoint endpoint, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
        ServerFactoryBean svrBean = endpoint.createServerFactoryBean();
        svrBean.setInvoker(new Invoker(){

            public Object invoke(org.apache.cxf.message.Exchange cxfExchange, Object o) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Received CXF Request: " + cxfExchange));
                }
                CxfEndpoint endpoint = (CxfEndpoint)CxfConsumer.this.getEndpoint();
                CxfBinding binding = endpoint.getCxfBinding();
                Exchange camelExchange = endpoint.createExchange();
                BindingOperationInfo boi = (BindingOperationInfo)cxfExchange.get(BindingOperationInfo.class);
                if (boi != null) {
                    camelExchange.setProperty(BindingOperationInfo.class.getName(), (Object)boi);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Set exchange property: BindingOperationInfo: " + boi));
                    }
                }
                DataFormat dataFormat = endpoint.getDataFormat();
                camelExchange.setProperty("CamelCXFDataFormat", (Object)dataFormat);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Set Exchange property: " + DataFormat.class.getName() + "=" + (Object)((Object)dataFormat)));
                }
                binding.populateExchangeFromCxfRequest(cxfExchange, camelExchange);
                try {
                    CxfConsumer.this.getProcessor().process(camelExchange);
                }
                catch (Exception e) {
                    throw new Fault((Throwable)e);
                }
                if (camelExchange.isFailed()) {
                    Exception t = camelExchange.hasOut() && camelExchange.getOut().isFault() ? (Throwable)camelExchange.getOut().getBody() : camelExchange.getException();
                    throw t instanceof Fault ? (Fault)t : new Fault((Throwable)t);
                }
                if (camelExchange.getPattern().isOutCapable()) {
                    binding.populateCxfResponseFromExchange(camelExchange, cxfExchange);
                }
                return null;
            }
        });
        this.server = svrBean.create();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.server.start();
    }

    protected void doStop() throws Exception {
        this.server.stop();
        super.doStop();
    }

    public Server getServer() {
        return this.server;
    }
}

