/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.ha;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.jndi2.ha.HAEntryPoint;
import fr.dyade.aaa.jndi2.ha.HARequestManager;
import fr.dyade.aaa.jndi2.ha.HATcpServer;
import fr.dyade.aaa.jndi2.server.AgentEntryPoint;
import fr.dyade.aaa.jndi2.server.Container;
import fr.dyade.aaa.jndi2.server.RequestManager;
import fr.dyade.aaa.jndi2.server.Trace;
import java.net.ServerSocket;
import org.objectweb.util.monolog.api.BasicLevel;

public class HAJndiServer {
    private static HATcpServer tcpServer;

    public static void init(String args, boolean firstTime) throws Exception {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("HAJndiServer.init(" + args + ',' + firstTime + ')'));
        }
        int port = Integer.parseInt(args);
        ServerSocket serverSocket = new ServerSocket(port);
        tcpServer = new HATcpServer(serverSocket, 3, HAJndiServer.getDefault());
        tcpServer.start();
        if (firstTime) {
            RequestManager manager = new RequestManager();
            HARequestManager haManager = new HARequestManager();
            haManager.setRequestManager(manager);
            AgentEntryPoint agentEP = new AgentEntryPoint();
            agentEP.setRequestManager(manager);
            HAEntryPoint haEP = new HAEntryPoint();
            haEP.setHARequestManager(haManager);
            Container container = new Container();
            container.addEntryPoint(agentEP);
            container.addEntryPoint(haEP);
            container.setLifeCycleListener(haManager);
            container.setBagSerializer(haManager);
            manager.setContainer(container);
            container.deploy();
        }
    }

    public static void stopService() {
        tcpServer.stop();
    }

    public static AgentId getDefault() {
        return HAJndiServer.getDefault(AgentServer.getServerId());
    }

    public static AgentId getDefault(short serverId) {
        return new AgentId(serverId, serverId, AgentId.LocalJndiServiceStamp);
    }
}

