/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.xmlschema;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.XmlSchemaInvalidOperation;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaFacet;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlSchemaTools {
    private static final Logger LOG = LogUtils.getL7dLogger(XmlSchemaTools.class);

    private XmlSchemaTools() {
    }

    private static void setNameFromQName(XmlSchemaElement element, QName name) {
        if (name == null) {
            element.setName(null);
        } else {
            element.setName(name.getLocalPart());
        }
    }

    public static void setElementQName(XmlSchemaElement element, QName name) {
        if (name != null && element.getRefName() != null && !element.getRefName().equals(name)) {
            LOG.severe("Attempt to set the QName of an element with a reference name");
            throw new XmlSchemaInvalidOperation("Attempt to set the QName of an element with a reference name.");
        }
        element.setQName(name);
        XmlSchemaTools.setNameFromQName(element, name);
    }

    public static void setElementName(XmlSchemaElement element, String name) {
        if (name != null && element.getRefName() != null && !element.getRefName().getLocalPart().equals(name) && (element.getQName() == null || element.getQName().getLocalPart().equals(name))) {
            LOG.severe("Attempt to set the name of an element with a reference name.");
            throw new XmlSchemaInvalidOperation("Attempt to set the name of an element with a reference name.");
        }
        element.setName(name);
    }

    public static void setElementRefName(XmlSchemaElement element, QName name) {
        if (name != null && (element.getQName() != null && !element.getQName().equals(name) || element.getName() != null && !element.getName().equals(name.getLocalPart()))) {
            LOG.severe("Attempt to set the refName of an element with a name or QName");
            throw new XmlSchemaInvalidOperation("Attempt to set the refName of an element with a name or QName.");
        }
        element.setRefName(name);
        XmlSchemaTools.setNameFromQName(element, name);
    }

    public static boolean isEumeration(XmlSchemaSimpleType type) {
        XmlSchemaSimpleTypeContent content = type.getContent();
        if (!(content instanceof XmlSchemaSimpleTypeRestriction)) {
            return false;
        }
        XmlSchemaSimpleTypeRestriction restriction = (XmlSchemaSimpleTypeRestriction)content;
        XmlSchemaObjectCollection facets = restriction.getFacets();
        for (int x = 0; x < facets.getCount(); ++x) {
            XmlSchemaFacet facet = (XmlSchemaFacet)facets.getItem(x);
            if (facet instanceof XmlSchemaEnumerationFacet) continue;
            return false;
        }
        return true;
    }

    public static List<String> enumeratorValues(XmlSchemaSimpleType type) {
        XmlSchemaSimpleTypeContent content = type.getContent();
        XmlSchemaSimpleTypeRestriction restriction = (XmlSchemaSimpleTypeRestriction)content;
        XmlSchemaObjectCollection facets = restriction.getFacets();
        ArrayList<String> values = new ArrayList<String>();
        for (int x = 0; x < facets.getCount(); ++x) {
            XmlSchemaFacet facet = (XmlSchemaFacet)facets.getItem(x);
            XmlSchemaEnumerationFacet enumFacet = (XmlSchemaEnumerationFacet)facet;
            values.add(enumFacet.getValue().toString());
        }
        return values;
    }
}

